/*
 * Decompiled with CFR 0.152.
 */
package cn.lzgabel;

import cn.lzgabel.bpmn.generator.internal.generated.model.TBaseElement;
import cn.lzgabel.bpmn.generator.internal.generated.model.TDefinitions;
import cn.lzgabel.bpmn.generator.internal.generated.model.TExtensionElements;
import cn.lzgabel.bpmn.generator.internal.generated.model.TFlowElement;
import cn.lzgabel.bpmn.generator.internal.generated.model.TProcess;
import cn.lzgabel.bpmn.generator.internal.generated.model.TRootElement;
import cn.lzgabel.bpmn.generator.internal.generated.model.TSubProcess;
import cn.lzgabel.layouter.SimpleGridLayouter;
import cn.lzgabel.util.BpmnInOut;
import cn.lzgabel.util.Util;
import cn.lzgabel.util.XmlParser;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.activiti.bpmn.converter.BpmnXMLConverter;
import org.activiti.bpmn.model.BpmnModel;

public class BpmnAutoLayout {
    private static Map<String, TExtensionElements> extensionElementsMap;

    public static String layout(String bpmn) throws Exception {
        extensionElementsMap = new HashMap<String, TExtensionElements>(16);
        XmlParser xmlParser = new XmlParser();
        TDefinitions originDefinitions = xmlParser.unmarshall(bpmn);
        originDefinitions.getRootElement().forEach(rootElement -> {
            TRootElement tRootElement = (TRootElement)rootElement.getValue();
            if (tRootElement instanceof TProcess) {
                TProcess process = (TProcess)tRootElement;
                process.getFlowElement().forEach(flowElement -> {
                    TFlowElement element = (TFlowElement)flowElement.getValue();
                    BpmnAutoLayout.stashExtensitionElements(element);
                });
            } else {
                BpmnAutoLayout.stashExtensitionElements(tRootElement);
            }
        });
        BpmnModel model = Util.readFromBpmn(bpmn);
        SimpleGridLayouter layouter = new SimpleGridLayouter(model);
        try {
            layouter.layoutModelToGrid(false);
        }
        catch (Exception e) {
            layouter = new SimpleGridLayouter(model);
            layouter.layoutModelToGrid(false);
        }
        layouter.applyGridToModel();
        byte[] xmlBytes = new BpmnXMLConverter().convertToXML(model);
        String xml = new String(xmlBytes);
        TDefinitions layoutedDefinitions = xmlParser.unmarshall(xml);
        layoutedDefinitions.setExporter("BPMNLayouter");
        layoutedDefinitions.setExporterVersion("1.0.0");
        layoutedDefinitions.getRootElement().forEach(rootElement -> {
            TRootElement tRootElement = (TRootElement)rootElement.getValue();
            if (tRootElement instanceof TProcess) {
                TProcess process = (TProcess)tRootElement;
                process.getFlowElement().forEach(flowElement -> {
                    TFlowElement element = (TFlowElement)flowElement.getValue();
                    BpmnAutoLayout.unStashExtensitionElements(element);
                });
            } else {
                BpmnAutoLayout.unStashExtensitionElements(tRootElement);
            }
        });
        BpmnInOut bpmnInOut = new BpmnInOut(xmlParser);
        String layoutedXml = bpmnInOut.writeToBpmn(layoutedDefinitions);
        return layoutedXml;
    }

    private static void stashExtensitionElements(TBaseElement element) {
        if (element instanceof TSubProcess) {
            TSubProcess subProcess = (TSubProcess)element;
            subProcess.getFlowElement().forEach(sub -> {
                TFlowElement subElement = (TFlowElement)sub.getValue();
                BpmnAutoLayout.stashExtensitionElements(subElement);
            });
        } else {
            TExtensionElements extensionElements = element.getExtensionElements();
            if (Objects.nonNull(extensionElements)) {
                extensionElementsMap.put(element.getId(), extensionElements);
            }
        }
    }

    private static void unStashExtensitionElements(TBaseElement element) {
        if (element instanceof TSubProcess) {
            TSubProcess subProcess = (TSubProcess)element;
            subProcess.getFlowElement().forEach(sub -> {
                TFlowElement subElement = (TFlowElement)sub.getValue();
                BpmnAutoLayout.unStashExtensitionElements(subElement);
            });
        } else if (extensionElementsMap.containsKey(element.getId())) {
            element.setExtensionElements(extensionElementsMap.get(element.getId()));
        }
    }
}

