/*
 * Decompiled with CFR 0.152.
 */
package cn.lzgabel.util;

import cn.lzgabel.bpmn.generator.internal.generated.model.ObjectFactory;
import cn.lzgabel.bpmn.generator.internal.generated.model.TDefinitions;
import cn.lzgabel.util.BpmnNamespacePrefixMapper;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

public class XmlParser {
    private static final JAXBContext context = XmlParser.initContext();

    private static JAXBContext initContext() {
        try {
            return JAXBContext.newInstance((Class[])new Class[]{TDefinitions.class});
        }
        catch (JAXBException e) {
            throw new RuntimeException("Unable to initialize the JAXBContext", e);
        }
    }

    public String marshal(TDefinitions definitions) {
        try {
            JAXBElement<TDefinitions> root = new ObjectFactory().createDefinitions(definitions);
            StringWriter stringWriter = new StringWriter();
            stringWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n");
            this.createMarshaller().marshal(root, (Writer)stringWriter);
            return stringWriter.toString();
        }
        catch (JAXBException e) {
            throw new RuntimeException("Unable to marshal", e);
        }
    }

    private Marshaller createMarshaller() throws JAXBException {
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        try {
            marshaller.setProperty("com.sun.xml.bind.namespacePrefixMapper", (Object)new BpmnNamespacePrefixMapper());
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            marshaller.setProperty("jaxb.fragment", (Object)true);
        }
        catch (PropertyException e) {
            e.printStackTrace();
        }
        return marshaller;
    }

    public TDefinitions unmarshall(String xml) {
        try {
            StreamSource source = new StreamSource(new StringReader(xml));
            JAXBElement root = context.createUnmarshaller().unmarshal((Source)source, TDefinitions.class);
            return (TDefinitions)root.getValue();
        }
        catch (JAXBException e) {
            throw new RuntimeException("Unable to marshal", e);
        }
    }
}

