/*
 * Decompiled with CFR 0.152.
 */
package cn.lzgabel.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.activiti.bpmn.converter.BpmnXMLConverter;
import org.activiti.bpmn.model.Activity;
import org.activiti.bpmn.model.Artifact;
import org.activiti.bpmn.model.Association;
import org.activiti.bpmn.model.BoundaryEvent;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.FlowNode;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.bpmn.model.SubProcess;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.filter.ElementFilter;
import org.jdom2.filter.Filter;
import org.jdom2.input.DOMBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.jdom2.util.IteratorIterable;
import org.xml.sax.SAXException;

public class Util {
    static boolean firstSortDone = false;
    static List<FlowNode> L;
    static List<SequenceFlow> B;
    static BpmnModel model;

    private static void safeXMLFile(String filename, Document document) throws IOException {
        XMLOutputter xmlOutput = new XMLOutputter();
        xmlOutput.setFormat(Format.getPrettyFormat());
        xmlOutput.output(document, (Writer)new FileWriter(filename));
    }

    public static List<FlowNode> topologicalSortNodes(Collection<FlowNode> flowNodes, BpmnModel model) {
        Util.model = model;
        L = new ArrayList<FlowNode>();
        B = new ArrayList<SequenceFlow>();
        ArrayList<FlowNode> flowNodeList = new ArrayList<FlowNode>();
        flowNodeList.addAll(flowNodes);
        ArrayList<FlowNode> S = new ArrayList<FlowNode>();
        while (!flowNodeList.isEmpty()) {
            S.clear();
            for (FlowNode element : flowNodeList) {
                if (element.getIncomingFlows().size() != 0 && !Util.allIncomingElementsAlreadyAdded(element.getIncomingFlows(), L)) continue;
                S.add(element);
            }
            if (!S.isEmpty()) {
                while (!S.isEmpty()) {
                    FlowNode n = (FlowNode)S.get(0);
                    flowNodeList.remove(S.remove(0));
                    L.add(n);
                    if (!(n instanceof Activity)) continue;
                    Iterator<Object> activity = (Activity)n;
                    List boundaryEvents = activity.getBoundaryEvents();
                    L.addAll(boundaryEvents);
                    for (BoundaryEvent boundaryEvent : boundaryEvents) {
                        String boundaryEventChildRef = Util.getBoundaryEventChildRef(boundaryEvent, model);
                        FlowNode boundaryEventChildNode = (FlowNode)model.getFlowElement(boundaryEventChildRef);
                        L.add(boundaryEventChildNode);
                        flowNodeList.remove(boundaryEventChildNode);
                    }
                }
                continue;
            }
            FlowNode J = null;
            for (FlowNode element : flowNodeList) {
                if (!Util.anyIncomingElementAlreadyAdded(element.getIncomingFlows(), L)) continue;
                J = element;
                break;
            }
            assert (J != null);
            for (SequenceFlow incomingFlow : J.getIncomingFlows()) {
                if (L.contains((FlowNode)model.getFlowElement(incomingFlow.getSourceRef()))) continue;
                B.add(incomingFlow);
            }
            for (SequenceFlow s : B) {
                Util.swapSourceAndTarget(s);
            }
        }
        for (SequenceFlow s : B) {
            Util.swapSourceAndTarget(s);
        }
        return L;
    }

    private static String getBoundaryEventChildRef(BoundaryEvent boundaryEvent, BpmnModel model) {
        if (boundaryEvent.getOutgoingFlows().size() == 1) {
            return ((SequenceFlow)boundaryEvent.getOutgoingFlows().get(0)).getTargetRef();
        }
        return Util.getAssociationTargetRef(boundaryEvent, model);
    }

    private static String getAssociationTargetRef(BoundaryEvent boundaryEvent, BpmnModel model) {
        String targetRef = Util.searchTargetRefInProcesses(boundaryEvent, model);
        if (targetRef == null) {
            targetRef = Util.searchTargetRefInSubProcesses(boundaryEvent, model);
        }
        return targetRef;
    }

    private static String searchTargetRefInSubProcesses(BoundaryEvent boundaryEvent, BpmnModel model2) {
        for (Process process : model.getProcesses()) {
            for (SubProcess subprocess : process.findFlowElementsOfType(SubProcess.class)) {
                for (Artifact artifact : subprocess.getArtifacts()) {
                    Association association;
                    if (!(artifact instanceof Association) || (association = (Association)artifact).getSourceRef() != boundaryEvent.getId()) continue;
                    return association.getTargetRef();
                }
            }
        }
        return null;
    }

    private static String searchTargetRefInProcesses(BoundaryEvent boundaryEvent, BpmnModel model) {
        for (Process process : model.getProcesses()) {
            for (Artifact artifact : process.getArtifacts()) {
                Association association;
                if (!(artifact instanceof Association) || !(association = (Association)artifact).getSourceRef().equals(boundaryEvent.getId())) continue;
                return association.getTargetRef();
            }
        }
        return null;
    }

    private static boolean anyIncomingElementAlreadyAdded(Collection<SequenceFlow> incomingFlows, List<FlowNode> L) {
        for (SequenceFlow incomingFlow : incomingFlows) {
            if (!L.contains((FlowNode)model.getFlowElement(incomingFlow.getSourceRef()))) continue;
            return true;
        }
        return false;
    }

    private static boolean allIncomingElementsAlreadyAdded(Collection<SequenceFlow> incomingFlows, List<FlowNode> L) {
        for (SequenceFlow incomingFlow : incomingFlows) {
            if (L.contains((FlowNode)model.getFlowElement(incomingFlow.getSourceRef()))) continue;
            return false;
        }
        return true;
    }

    private static void swapSourceAndTarget(SequenceFlow s) {
        FlowNode source = (FlowNode)model.getFlowElement(s.getSourceRef());
        FlowNode target = (FlowNode)model.getFlowElement(s.getTargetRef());
        source.getOutgoingFlows().remove(s);
        source.getIncomingFlows().add(s);
        target.getIncomingFlows().remove(s);
        target.getOutgoingFlows().add(s);
        s.setSourceRef(target.getId());
        s.setTargetRef(source.getId());
    }

    public static void writeModel(BpmnModel model, String name) throws IOException, FileNotFoundException {
        byte[] xml = new BpmnXMLConverter().convertToXML(model);
        try (FileOutputStream out = new FileOutputStream(name);){
            out.write(xml);
        }
    }

    public static BpmnModel readBPMFile(File file) throws XMLStreamException, FactoryConfigurationError, FileNotFoundException {
        XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(new FileInputStream(file));
        BpmnModel model = new BpmnXMLConverter().convertToBpmnModel(reader);
        return model;
    }

    public static BpmnModel readFromBpmn(String xml) throws XMLStreamException, FactoryConfigurationError {
        XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(new ByteArrayInputStream(xml.getBytes()));
        BpmnModel model = new BpmnXMLConverter().convertToBpmnModel(reader);
        return model;
    }

    private static List<BoundaryEvent> getBoundaryEvents(FlowNode node) {
        if (node instanceof Activity) {
            Activity activity = (Activity)node;
            return activity.getBoundaryEvents();
        }
        return null;
    }

    public static void addXMLElementsBackToFile(HashMap<String, Element> extensionMap, String filename) throws IOException, ParserConfigurationException, SAXException {
        Document document = Util.parseXMLFile(filename);
        Element rootElement = document.getRootElement();
        IteratorIterable elementIterator = rootElement.getDescendants((Filter)new ElementFilter());
        ArrayList<Element> parents = new ArrayList<Element>();
        while (elementIterator.hasNext()) {
            Element currentElement = (Element)elementIterator.next();
            String id = currentElement.getAttributeValue("id");
            if (id == null || !extensionMap.containsKey(id)) continue;
            parents.add(currentElement);
        }
        for (Element parent : parents) {
            String id = parent.getAttributeValue("id");
            parent.addContent((Content)extensionMap.get(id));
        }
        Util.safeXMLFile(filename, document);
    }

    private static Document parseXMLFile(String filename) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = factory.newDocumentBuilder();
        org.w3c.dom.Document w3cDocument = documentBuilder.parse(filename);
        Document document = new DOMBuilder().build(w3cDocument);
        return document;
    }

    public static HashMap<String, Element> removeAndGetElementsFromXML(String filePath, String elementName) throws ParserConfigurationException, SAXException, IOException {
        HashMap<String, Element> elementMap = new HashMap<String, Element>();
        Document document = Util.parseXMLFile(filePath);
        Element rootElement = document.getRootElement();
        IteratorIterable elementIterator = rootElement.getDescendants((Filter)new ElementFilter(elementName));
        while (elementIterator.hasNext()) {
            Element currentElement = (Element)elementIterator.next();
            Element sedParent = (Element)currentElement.getParent();
            String id = sedParent.getAttributeValue("id");
            elementMap.put(id, currentElement);
        }
        for (Element element : elementMap.values()) {
            element.detach();
        }
        Util.safeXMLFile(filePath, document);
        return elementMap;
    }
}

