/*
 * Decompiled with CFR 0.152.
 */
package cn.lzgabel.model.grid;

import cn.lzgabel.model.grid.Cell;
import cn.lzgabel.model.grid.CellFlag;
import cn.lzgabel.model.grid.GridPosition;
import cn.lzgabel.model.grid.GridSize;
import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.activiti.bpmn.model.FlowNode;

public class Grid<T> {
    private List<List<Cell<T>>> columns = new ArrayList<List<Cell<T>>>();
    private HashMap<T, Cell<T>> cellmap = new HashMap();
    private GridPosition gridPosition = new GridPosition(0, 0);
    private Point absolutePosition = new Point();
    private Dimension absoluteSize = new Dimension();
    private int cellHeight;
    private int cellWidth;
    private Cell<T> destCell;
    private boolean isEmpty = true;

    public Grid() {
        this.columns.add(new ArrayList());
        this.columns.get(0).add(new Cell(0, 0));
    }

    public GridSize getGridSize() {
        return new GridSize(this.columns.get(0).size(), this.columns.size());
    }

    public void addRowsBelowAndAbovePosition(GridPosition position, int rowCount) {
        for (int i = 1; i < rowCount; ++i) {
            if (i % 2 == 0) {
                this.addRowAbove(position.row);
            }
            if (i % 2 != 1) continue;
            this.addRowBelow(position.row);
        }
    }

    public void createAndReserveCells(GridPosition position, Grid<FlowNode> spGrid) {
        GridPosition subProcessPosition = new GridPosition(position);
        for (List<Cell<FlowNode>> col : spGrid.getColumns()) {
            Iterator<Cell<FlowNode>> iterator = col.iterator();
            while (iterator.hasNext()) {
                if (subProcessPosition.row > this.getGridSize().rows() - 1) {
                    this.addLastRow();
                }
                this.addValue(null, subProcessPosition);
                this.getCell((GridPosition)subProcessPosition).flag = CellFlag.RESERVED;
                ++subProcessPosition.row;
                iterator.next();
            }
            subProcessPosition.row = position.row;
            ++subProcessPosition.column;
        }
    }

    public void shiftFlowNode(T node, int distance) throws ArrayIndexOutOfBoundsException {
        Cell<T> sourceCell = this.getCellByValue(node);
        int col = this.getColumnOf(sourceCell);
        int row = this.getColumns().get(col).indexOf(sourceCell);
        this.destCell = null;
        while (this.destCell == null) {
            List<Cell<T>> column = null;
            if (this.getColumns().size() <= col + distance) {
                this.addColumn();
                continue;
            }
            column = this.getColumns().get(col + distance);
            if (column.size() <= row) {
                column.add(new Cell(col, column.size() - 1));
                continue;
            }
            this.destCell = column.get(row);
        }
        this.moveCellContent(sourceCell, this.destCell);
    }

    public void appendGrid(Grid<T> g) {
        this.isEmpty = false;
        int colIndex = 0;
        int originalRowSize = this.getGridSize().rows();
        for (List<Cell<T>> column : g.getColumns()) {
            if (this.columns.size() == colIndex) {
                this.addColumn(originalRowSize);
            }
            for (Cell<T> cell : column) {
                this.getColumns().get(colIndex).add(cell);
            }
            ++colIndex;
        }
        while (colIndex != this.columns.size()) {
            while (this.getColumns().get(0).size() != this.getColumns().get(colIndex).size()) {
                this.getColumns().get(colIndex).add(new Cell(0, 0));
            }
            ++colIndex;
        }
        this.cellmap.putAll(g.cellmap);
    }

    public T getValueFromCell(int row, int col) {
        return this.columns.get(col).get(row).getValue();
    }

    public Cell<T> addValueToCell(T value, int row, int col) {
        int freeColumn = col;
        while (freeColumn >= this.columns.size()) {
            this.addColumn(this.getGridSize().rows());
        }
        Cell<T> cell = this.columns.get(freeColumn).get(row);
        while (cell.getValue() != null) {
            this.addColumn(this.getGridSize().rows());
            cell = this.columns.get(++freeColumn).get(row);
        }
        if (value != null) {
            cell.setValue(value);
            this.cellmap.put(value, cell);
        }
        return cell;
    }

    public Cell<T> getCellByValue(T value) {
        return this.cellmap.get(value);
    }

    public void addColumn(int rows) {
        ArrayList<Cell<T>> col = new ArrayList<Cell<T>>();
        this.fillColumnWithRows(col, rows);
        this.columns.add(col);
    }

    public void addColumn() {
        ArrayList<Cell<T>> col = new ArrayList<Cell<T>>();
        this.fillColumnWithRows(col, this.getGridSize().rows());
        this.columns.add(col);
    }

    private void fillColumnWithRows(ArrayList<Cell<T>> col, int rows) {
        for (int i = 0; i < rows; ++i) {
            col.add(new Cell(i, this.columns.size()));
        }
    }

    public void addRowAbove(int rowIndex) {
        for (List<Cell<T>> row : this.columns) {
            row.add(rowIndex, new Cell(rowIndex, row.get((int)0).gridPosition.column));
            for (int i = rowIndex + 1; i < row.size(); ++i) {
                ++row.get((int)i).gridPosition.row;
            }
        }
    }

    public void addRowBelow(int rowIndex) {
        for (List<Cell<T>> row : this.columns) {
            row.add(rowIndex + 1, new Cell(rowIndex + 1, row.get((int)0).gridPosition.column));
            for (int i = rowIndex + 2; i < row.size(); ++i) {
                ++row.get((int)i).gridPosition.row;
            }
        }
    }

    public List<List<Cell<T>>> getColumns() {
        return this.columns;
    }

    public int getColumnOf(Cell<T> cell) {
        for (List<Cell<T>> column : this.columns) {
            if (!column.contains(cell)) continue;
            return this.columns.indexOf(column);
        }
        return -1;
    }

    public void updateCellMap(Cell<T> newCell) {
        this.cellmap.remove(newCell.getValue());
        this.cellmap.put(newCell.getValue(), newCell);
    }

    public void moveCellContent(Cell<T> sourceCell, Cell<T> destCell) {
        CellFlag sourceFlag;
        destCell.setValue(sourceCell.getValue());
        destCell.flag = sourceFlag = sourceCell.flag;
        sourceCell.flag = CellFlag.FREE;
        sourceCell.setValue(null);
        this.updateCellMap(destCell);
    }

    public Cell<T> getCell(GridPosition position) {
        try {
            return this.columns.get(position.column).get(position.row);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    public void addValue(T value, GridPosition position) {
        this.addValueToCell(value, position.row, position.column);
    }

    public void addLastRow() {
        this.addRowBelow(this.columns.get(0).size() - 1);
    }

    public void setCellsize(int cellHeight, int cellWidth) {
        this.cellHeight = cellHeight;
        this.cellWidth = cellWidth;
    }

    public GridPosition getGridPosition() {
        return this.gridPosition;
    }

    public void setGridPosition(GridPosition gridPosition) {
        this.gridPosition = gridPosition;
    }

    public Point getAbsolutePosition() {
        this.absolutePosition.x = this.gridPosition.column * this.cellWidth;
        this.absolutePosition.y = this.gridPosition.row * this.cellHeight;
        return this.absolutePosition;
    }

    public Dimension getAbsoluteSize() {
        this.absoluteSize.setSize(this.columns.size() * this.cellWidth, this.columns.get(0).size() * this.cellHeight);
        return this.absoluteSize;
    }

    public void moveCellContent(GridPosition sourcePosition, GridPosition destPosition) {
        Cell<T> source = this.getCell(sourcePosition);
        Cell<T> target = this.getCell(destPosition);
        this.moveCellContent(source, target);
    }

    public boolean isEmpty() {
        return this.cellmap.isEmpty() && this.isEmpty;
    }

    public HashMap<T, Cell<T>> getCellMap() {
        return this.cellmap;
    }

    public Cell<T> getCell(int row, int column) {
        return this.getCell(new GridPosition(row, column));
    }
}

