/*
 * Decompiled with CFR 0.152.
 */
package cn.lzgabel.model.grid;

import cn.lzgabel.model.grid.CellFlag;
import cn.lzgabel.model.grid.GridPosition;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class Cell<T> {
    private T value;
    public GridPosition gridPosition;
    public Point absolutePosition;
    public CellFlag flag = CellFlag.FREE;
    private List<T> docks = new ArrayList<T>();
    private HashMap<T, Point> dockPositionMap = new HashMap();

    public Cell(T value, int row, int col) {
        this.value = value;
        this.flag = CellFlag.TAKEN;
        this.gridPosition = new GridPosition(row, col);
    }

    public Cell(int row, int col) {
        this.gridPosition = new GridPosition(row, col);
    }

    public String toString() {
        return this.value.toString();
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.flag = CellFlag.TAKEN;
        this.value = value;
    }

    public void addDock(T value) {
        this.docks.add(value);
    }

    public List<T> getDocks() {
        return this.docks;
    }

    public Point getAbsolutPositionOfDock(T attachedTo) {
        return this.dockPositionMap.get(attachedTo);
    }

    public void setAbsolutePositionOfDock(T dock, Point position) {
        this.dockPositionMap.put(dock, position);
    }
}

