/*
 * Decompiled with CFR 0.152.
 */
package cn.lzgabel.layouter;

import cn.lzgabel.util.FlowInformation;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import org.activiti.bpmn.model.Artifact;
import org.activiti.bpmn.model.Association;
import org.activiti.bpmn.model.BoundaryEvent;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.FlowElementsContainer;
import org.activiti.bpmn.model.FlowNode;
import org.activiti.bpmn.model.Gateway;
import org.activiti.bpmn.model.GraphicInfo;
import org.activiti.bpmn.model.Lane;
import org.activiti.bpmn.model.MessageFlow;
import org.activiti.bpmn.model.Pool;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.bpmn.model.SubProcess;

public class SimpleOrthogonalFlowRouter {
    private static BpmnModel model;

    public static void routeFlows(BpmnModel model) {
        SimpleOrthogonalFlowRouter.model = model;
        List<FlowNode> flowNodes = SimpleOrthogonalFlowRouter.gatherAllFlowNodes(model);
        ArrayList<List<GraphicInfo>> flowNodeGraphicInfoLists = new ArrayList<List<GraphicInfo>>();
        for (FlowNode flowNode : flowNodes) {
            for (SequenceFlow sequenceFlow : flowNode.getOutgoingFlows()) {
                List<GraphicInfo> giList = SimpleOrthogonalFlowRouter.updateFlowGraphicInfo(sequenceFlow);
                if (giList == null) continue;
                flowNodeGraphicInfoLists.add(giList);
            }
        }
        for (MessageFlow messageFlow : model.getMessageFlows().values()) {
            List<GraphicInfo> giList = SimpleOrthogonalFlowRouter.updateFlowGraphicInfo(messageFlow);
            if (giList == null) continue;
            flowNodeGraphicInfoLists.add(giList);
        }
        for (Process process : model.getProcesses()) {
            for (Artifact artifact : process.getArtifacts()) {
                Association association;
                List<GraphicInfo> giList;
                if (!(artifact instanceof Association) || (giList = SimpleOrthogonalFlowRouter.updateFlowGraphicInfo(association = (Association)artifact)) == null) continue;
                flowNodeGraphicInfoLists.add(giList);
            }
        }
    }

    private static List<GraphicInfo> updateFlowGraphicInfo(Object flowType) {
        FlowInformation fi = SimpleOrthogonalFlowRouter.getFlowInformation(flowType);
        if (fi == null) {
            return null;
        }
        String iD = fi.iD;
        String sourceRef = fi.sourceRef;
        String targetRef = fi.targetRef;
        List graphicInfoList = model.getFlowLocationGraphicInfo(iD);
        ArrayList<GraphicInfo> bends = new ArrayList<GraphicInfo>();
        graphicInfoList.clear();
        GraphicInfo sourceFlowGI = new GraphicInfo();
        GraphicInfo sourceNodeGI = model.getGraphicInfo(sourceRef);
        FlowNode sourceNode = (FlowNode)model.getFlowElement(sourceRef);
        GraphicInfo targetFlowGI = new GraphicInfo();
        GraphicInfo targetNodeGI = model.getGraphicInfo(targetRef);
        FlowNode targetNode = (FlowNode)model.getFlowElement(targetRef);
        Point sourceNodeCenter = null;
        Point targetNodeCenter = null;
        Point sourceCenterPoint = SimpleOrthogonalFlowRouter.getCenterPoint(sourceNodeGI);
        Point targetCenterPoint = SimpleOrthogonalFlowRouter.getCenterPoint(targetNodeGI);
        if (sourceCenterPoint.getX() < targetCenterPoint.getX() && sourceCenterPoint.getY() == targetCenterPoint.getY()) {
            sourceNodeCenter = SimpleOrthogonalFlowRouter.getRightCenterPoint(sourceNodeGI);
            targetNodeCenter = SimpleOrthogonalFlowRouter.getLeftCenterPoint(targetNodeGI);
            if (targetNode instanceof Gateway) {
                sourceNodeCenter = SimpleOrthogonalFlowRouter.getRightCenterPoint(sourceNodeGI);
                targetNodeCenter = SimpleOrthogonalFlowRouter.getLeftCenterPoint(targetNodeGI);
            }
        }
        if (sourceCenterPoint.getX() < targetCenterPoint.getX() && sourceCenterPoint.getY() > targetCenterPoint.getY()) {
            sourceNodeCenter = SimpleOrthogonalFlowRouter.getCenterTopPoint(sourceNodeGI);
            targetNodeCenter = SimpleOrthogonalFlowRouter.getLeftCenterPoint(targetNodeGI);
            if (targetNode instanceof Gateway) {
                sourceNodeCenter = SimpleOrthogonalFlowRouter.getRightCenterPoint(sourceNodeGI);
                targetNodeCenter = SimpleOrthogonalFlowRouter.getCenterBottomPoint(targetNodeGI);
            }
        }
        if (sourceCenterPoint.getX() < targetCenterPoint.getX() && sourceCenterPoint.getY() < targetCenterPoint.getY()) {
            sourceNodeCenter = SimpleOrthogonalFlowRouter.getCenterBottomPoint(sourceNodeGI);
            targetNodeCenter = SimpleOrthogonalFlowRouter.getLeftCenterPoint(targetNodeGI);
            if (!(sourceNode instanceof Gateway) && targetNode instanceof Gateway) {
                sourceNodeCenter = SimpleOrthogonalFlowRouter.getRightCenterPoint(sourceNodeGI);
                targetNodeCenter = SimpleOrthogonalFlowRouter.getCenterTopPoint(targetNodeGI);
            }
        }
        if (sourceCenterPoint.getX() == targetCenterPoint.getX() && sourceCenterPoint.getY() > targetCenterPoint.getY()) {
            sourceNodeCenter = SimpleOrthogonalFlowRouter.getCenterTopPoint(sourceNodeGI);
            targetNodeCenter = SimpleOrthogonalFlowRouter.getCenterBottomPoint(targetNodeGI);
        }
        if (sourceCenterPoint.getX() == targetCenterPoint.getX() && sourceCenterPoint.getY() > targetCenterPoint.getY()) {
            sourceNodeCenter = SimpleOrthogonalFlowRouter.getCenterBottomPoint(sourceNodeGI);
            targetNodeCenter = SimpleOrthogonalFlowRouter.getCenterTopPoint(targetNodeGI);
        }
        if (model.getPool(sourceRef) != null) {
            sourceFlowGI.setX(targetNodeCenter.getX());
            if (sourceNodeGI.getY() < targetNodeGI.getY()) {
                sourceFlowGI.setY(sourceNodeGI.getY() + sourceNodeGI.getHeight());
                targetFlowGI.setY(targetNodeCenter.getY() - targetNodeGI.getHeight() * 0.5);
            } else {
                sourceFlowGI.setY(sourceNodeGI.getY());
                targetFlowGI.setY(targetNodeCenter.getY() + targetNodeGI.getHeight() * 0.5);
            }
            graphicInfoList.add(sourceFlowGI);
            targetFlowGI.setX(targetNodeCenter.getX());
            graphicInfoList.add(targetFlowGI);
            return null;
        }
        if (model.getPool(targetRef) != null) {
            sourceFlowGI.setX(sourceNodeCenter.getX());
            graphicInfoList.add(sourceFlowGI);
            targetFlowGI.setX(sourceNodeCenter.getX());
            if (targetNodeGI.getY() < sourceNodeGI.getY()) {
                sourceFlowGI.setY(sourceNodeCenter.getY() - sourceNodeGI.getHeight() * 0.5);
                targetFlowGI.setY(targetNodeGI.getY() + targetNodeGI.getHeight());
            } else {
                sourceFlowGI.setY(sourceNodeCenter.getY() + sourceNodeGI.getHeight() * 0.5);
                targetFlowGI.setY(targetNodeGI.getY());
            }
            graphicInfoList.add(targetFlowGI);
            return null;
        }
        if (sourceNode == null) {
            return null;
        }
        double sourceX = sourceNodeGI.getX();
        double sourceY = sourceNodeGI.getY();
        double targetX = targetNodeGI.getX();
        double targetY = targetNodeGI.getY();
        if (sourceNode instanceof BoundaryEvent) {
            sourceX = sourceNodeGI.getX() + sourceNodeGI.getWidth() / 2.0;
            sourceY = sourceNodeGI.getY() + sourceNodeGI.getHeight() / 2.0;
            GraphicInfo bendGI = new GraphicInfo();
            bendGI.setX(sourceX);
            bendGI.setY(targetY += targetNodeGI.getHeight() / 2.0);
            bends.add(bendGI);
        } else if (Math.abs(sourceNodeCenter.getY() - targetNodeCenter.getY()) < 3.0) {
            sourceY += sourceNodeGI.getHeight() / 2.0;
            if (sourceNodeCenter.getX() < targetNodeCenter.getX()) {
                sourceX += sourceNodeGI.getWidth();
                targetY += targetNodeGI.getHeight() / 2.0;
            }
        } else if (Math.abs(sourceNodeCenter.getX() - targetNodeCenter.getX()) < 3.0) {
            sourceX += sourceNodeGI.getWidth() / 2.0;
            if (sourceNodeCenter.getY() < targetNodeCenter.getY()) {
                sourceY += sourceNodeGI.getHeight();
                targetX += targetNodeGI.getWidth() / 2.0;
            } else {
                targetY += sourceNodeGI.getHeight();
                targetX += targetNodeGI.getWidth() / 2.0;
            }
        } else if (sourceNodeCenter.getY() > targetNodeCenter.getY()) {
            if (flowType instanceof MessageFlow) {
                int poolMiddleCoordinate = SimpleOrthogonalFlowRouter.getPoolMiddleCoordinate((MessageFlow)flowType);
                int offset = 0;
                int direction = 1;
                while (SimpleOrthogonalFlowRouter.horizontalLineIsOverlapping(poolMiddleCoordinate, sourceNodeCenter.x, targetNodeCenter.x, offset)) {
                    if (direction == 1) {
                        offset = Math.abs(offset) + 5;
                        direction *= -1;
                        continue;
                    }
                    offset = direction * offset;
                    direction *= -1;
                }
                GraphicInfo bend1 = new GraphicInfo();
                bend1.setX((double)sourceNodeCenter.x);
                bend1.setY((double)(poolMiddleCoordinate + offset));
                bends.add(bend1);
                GraphicInfo bend2 = new GraphicInfo();
                bend2.setX((double)targetNodeCenter.x);
                bend2.setY((double)(poolMiddleCoordinate + offset));
                bends.add(bend2);
            } else if (sourceNode.getOutgoingFlows().size() == 1) {
                sourceX += sourceNodeGI.getWidth();
                targetY += targetNodeGI.getHeight();
                GraphicInfo bendGI = new GraphicInfo();
                bendGI.setX(targetX += targetNodeGI.getWidth() / 2.0);
                bendGI.setY(sourceY += sourceNodeGI.getHeight() / 2.0);
                bends.add(bendGI);
            } else if (sourceNode.getOutgoingFlows().size() > 1) {
                sourceX = sourceNodeGI.getX() + sourceNodeGI.getWidth() / 2.0;
                sourceY = sourceNodeGI.getY() + sourceNodeGI.getHeight() / 2.0;
                GraphicInfo bendGI = new GraphicInfo();
                bendGI.setX(sourceX);
                bendGI.setY(targetY += targetNodeGI.getHeight() / 2.0);
                bends.add(bendGI);
            }
        } else if (sourceNodeCenter.getY() < targetNodeCenter.getY()) {
            if (flowType instanceof MessageFlow) {
                int poolMiddleCoordinate = SimpleOrthogonalFlowRouter.getPoolMiddleCoordinate((MessageFlow)flowType);
                int yOffset = 0;
                int yOffsetDirection = 1;
                while (SimpleOrthogonalFlowRouter.horizontalLineIsOverlapping(poolMiddleCoordinate, sourceNodeCenter.x, targetNodeCenter.x, yOffset)) {
                    yOffset = (yOffsetDirection *= -1) * (Math.abs(yOffset) + 5);
                }
                GraphicInfo bend1 = new GraphicInfo();
                bend1.setX((double)sourceNodeCenter.x);
                bend1.setY((double)(poolMiddleCoordinate + yOffset));
                bends.add(bend1);
                GraphicInfo bend2 = new GraphicInfo();
                bend2.setX((double)targetNodeCenter.x);
                bend2.setY((double)(poolMiddleCoordinate + yOffset));
                bends.add(bend2);
            } else if (sourceNode.getOutgoingFlows().size() == 1) {
                sourceX += sourceNodeGI.getWidth();
                GraphicInfo bendGI = new GraphicInfo();
                bendGI.setX(targetX += targetNodeGI.getWidth() / 2.0);
                bendGI.setY(sourceY += sourceNodeGI.getHeight() / 2.0);
                bends.add(bendGI);
            } else if (sourceNode.getOutgoingFlows().size() > 1) {
                sourceX = sourceNodeGI.getX() + sourceNodeGI.getWidth() / 2.0;
                sourceY = sourceNodeGI.getY() + sourceNodeGI.getHeight() / 2.0;
                GraphicInfo bendGI = new GraphicInfo();
                bendGI.setX(sourceX);
                bendGI.setY(targetY += targetNodeGI.getHeight() / 2.0);
                bends.add(bendGI);
            }
        }
        sourceFlowGI.setX((double)sourceNodeCenter.x);
        sourceFlowGI.setY((double)sourceNodeCenter.y);
        graphicInfoList.add(sourceFlowGI);
        graphicInfoList.addAll(bends);
        targetFlowGI.setX((double)targetNodeCenter.x);
        targetFlowGI.setY((double)targetNodeCenter.y);
        graphicInfoList.add(targetFlowGI);
        return graphicInfoList;
    }

    private static boolean horizontalLineIsOverlapping(int y, int x1, int x2, int yOffset) {
        for (MessageFlow messageFlow : model.getMessageFlows().values()) {
            List graphicInfoList = model.getFlowLocationGraphicInfo(messageFlow.getId());
            int currentYCoordinate = y + yOffset;
            for (int i = 0; i < graphicInfoList.size() - 1; ++i) {
                if (((GraphicInfo)graphicInfoList.get(i)).getY() != ((GraphicInfo)graphicInfoList.get(i + 1)).getY() || (double)currentYCoordinate != ((GraphicInfo)graphicInfoList.get(i)).getY()) continue;
                if (((GraphicInfo)graphicInfoList.get(i)).getX() < ((GraphicInfo)graphicInfoList.get(i + 1)).getX()) {
                    if ((double)x1 > ((GraphicInfo)graphicInfoList.get(i)).getX() && (double)x1 < ((GraphicInfo)graphicInfoList.get(i + 1)).getX()) {
                        return true;
                    }
                    if ((double)x2 > ((GraphicInfo)graphicInfoList.get(i)).getX() && (double)x2 < ((GraphicInfo)graphicInfoList.get(i + 1)).getX()) {
                        return true;
                    }
                }
                if (!(((GraphicInfo)graphicInfoList.get(i)).getX() > ((GraphicInfo)graphicInfoList.get(i + 1)).getX())) continue;
                if ((double)x1 < ((GraphicInfo)graphicInfoList.get(i)).getX() && (double)x1 > ((GraphicInfo)graphicInfoList.get(i + 1)).getX()) {
                    return true;
                }
                if (!((double)x2 < ((GraphicInfo)graphicInfoList.get(i)).getX()) || !((double)x2 > ((GraphicInfo)graphicInfoList.get(i + 1)).getX())) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean verticalLineIsOverlapping(int x, int y1, int y2, int xOffset) {
        for (MessageFlow messageFlow : model.getMessageFlows().values()) {
            List graphicInfoList = model.getFlowLocationGraphicInfo(messageFlow.getId());
            int currentXCoordinate = x + xOffset;
            for (int i = 0; i < graphicInfoList.size() - 1; ++i) {
                if (((GraphicInfo)graphicInfoList.get(i)).getX() != ((GraphicInfo)graphicInfoList.get(i + 1)).getX() || (double)currentXCoordinate != ((GraphicInfo)graphicInfoList.get(i)).getX()) continue;
                if (((GraphicInfo)graphicInfoList.get(i)).getY() < ((GraphicInfo)graphicInfoList.get(i + 1)).getY()) {
                    if ((double)x > ((GraphicInfo)graphicInfoList.get(i)).getY() && (double)x < ((GraphicInfo)graphicInfoList.get(i + 1)).getY()) {
                        return true;
                    }
                    if ((double)y2 > ((GraphicInfo)graphicInfoList.get(i)).getY() && (double)y2 < ((GraphicInfo)graphicInfoList.get(i + 1)).getY()) {
                        return true;
                    }
                }
                if (!(((GraphicInfo)graphicInfoList.get(i)).getY() > ((GraphicInfo)graphicInfoList.get(i + 1)).getY())) continue;
                if ((double)x < ((GraphicInfo)graphicInfoList.get(i)).getY() && (double)x > ((GraphicInfo)graphicInfoList.get(i + 1)).getY()) {
                    return true;
                }
                if (!((double)y2 < ((GraphicInfo)graphicInfoList.get(i)).getY()) || !((double)y2 > ((GraphicInfo)graphicInfoList.get(i + 1)).getY())) continue;
                return true;
            }
        }
        return false;
    }

    private static FlowInformation getFlowInformation(Object flowType) {
        FlowInformation fi = new FlowInformation();
        if (flowType instanceof SequenceFlow) {
            SequenceFlow seqFlow = (SequenceFlow)flowType;
            fi.iD = seqFlow.getId();
            fi.sourceRef = seqFlow.getSourceRef();
            fi.targetRef = seqFlow.getTargetRef();
        }
        if (flowType instanceof MessageFlow) {
            MessageFlow msgFlow = (MessageFlow)flowType;
            fi.iD = msgFlow.getId();
            fi.sourceRef = msgFlow.getSourceRef();
            fi.targetRef = msgFlow.getTargetRef();
        }
        if (flowType instanceof Association) {
            Association association = (Association)flowType;
            fi.iD = association.getId();
            fi.sourceRef = association.getSourceRef();
            fi.targetRef = association.getTargetRef();
            if (!(model.getFlowElement(fi.sourceRef) instanceof FlowNode)) {
                return null;
            }
            if (!(model.getFlowElement(fi.targetRef) instanceof FlowNode)) {
                return null;
            }
        }
        return fi;
    }

    private static int getPoolMiddleCoordinate(MessageFlow flow) {
        GraphicInfo targetNodeGI;
        GraphicInfo sourceNodeGI;
        Pool sourceNodePool = SimpleOrthogonalFlowRouter.getPoolOfNode(flow.getSourceRef());
        Pool targetNodePool = SimpleOrthogonalFlowRouter.getPoolOfNode(flow.getTargetRef());
        Lane sourceNodeLane = SimpleOrthogonalFlowRouter.getLaneOfNode(flow.getSourceRef());
        Lane targetNodeLane = SimpleOrthogonalFlowRouter.getLaneOfNode(flow.getTargetRef());
        if (sourceNodePool != null) {
            sourceNodeGI = model.getGraphicInfo(sourceNodePool.getId());
        } else if (sourceNodeLane != null) {
            sourceNodeGI = model.getGraphicInfo(sourceNodeLane.getId());
        } else {
            return 0;
        }
        if (targetNodePool != null) {
            targetNodeGI = model.getGraphicInfo(targetNodePool.getId());
        } else if (targetNodeLane != null) {
            targetNodeGI = model.getGraphicInfo(targetNodeLane.getId());
        } else {
            return 0;
        }
        if (sourceNodeGI.getY() > targetNodeGI.getY()) {
            return (int)(sourceNodeGI.getY() - 60.0);
        }
        return (int)(targetNodeGI.getY() - 60.0);
    }

    private static Lane getLaneOfNode(String iD) {
        for (Process process : model.getProcesses()) {
            for (Lane lane : process.getLanes()) {
                if (!lane.getFlowReferences().contains(iD)) continue;
                return lane;
            }
        }
        return null;
    }

    private static Pool getPoolOfNode(String ref) {
        for (Pool pool : model.getPools()) {
            Process process = model.getProcess(pool.getId());
            if (process == null) continue;
            if (process.getFlowElement(ref) != null) {
                return pool;
            }
            for (SubProcess subprocess : process.findFlowElementsOfType(SubProcess.class)) {
                if (subprocess.getFlowElement(ref) == null) continue;
                return pool;
            }
        }
        return null;
    }

    private static Point getCenterPoint(GraphicInfo sourceNodeGI) {
        int x = (int)(sourceNodeGI.getX() + sourceNodeGI.getWidth() / 2.0);
        int y = (int)(sourceNodeGI.getY() + sourceNodeGI.getHeight() / 2.0);
        return new Point(x, y);
    }

    private static Point getCenterTopPoint(GraphicInfo sourceNodeGI) {
        int x = (int)(sourceNodeGI.getX() + sourceNodeGI.getWidth() / 2.0);
        int y = (int)sourceNodeGI.getY();
        return new Point(x, y);
    }

    private static Point getCenterBottomPoint(GraphicInfo sourceNodeGI) {
        int x = (int)(sourceNodeGI.getX() + sourceNodeGI.getWidth() / 2.0);
        int y = (int)(sourceNodeGI.getY() + sourceNodeGI.getHeight());
        return new Point(x, y);
    }

    private static Point getRightCenterPoint(GraphicInfo sourceNodeGI) {
        int x = (int)(sourceNodeGI.getX() + sourceNodeGI.getWidth());
        int y = (int)(sourceNodeGI.getY() + sourceNodeGI.getHeight() / 2.0);
        return new Point(x, y);
    }

    private static Point getLeftCenterPoint(GraphicInfo sourceNodeGI) {
        int x = (int)sourceNodeGI.getX();
        int y = (int)(sourceNodeGI.getY() + sourceNodeGI.getHeight() / 2.0);
        return new Point(x, y);
    }

    private static List<FlowNode> gatherAllFlowNodes(BpmnModel model) {
        ArrayList<FlowNode> flowNodes = new ArrayList<FlowNode>();
        for (Process process : model.getProcesses()) {
            flowNodes.addAll(SimpleOrthogonalFlowRouter.gatherAllFlowNodes((FlowElementsContainer)process));
        }
        return flowNodes;
    }

    private static List<FlowNode> gatherAllFlowNodes(FlowElementsContainer flowElementsContainer) {
        ArrayList<FlowNode> flowNodes = new ArrayList<FlowNode>();
        for (FlowElement flowElement : flowElementsContainer.getFlowElements()) {
            if (flowElement instanceof FlowNode) {
                flowNodes.add((FlowNode)flowElement);
            }
            if (!(flowElement instanceof FlowElementsContainer)) continue;
            flowNodes.addAll(SimpleOrthogonalFlowRouter.gatherAllFlowNodes((FlowElementsContainer)flowElement));
        }
        return flowNodes;
    }
}

