/*
 * Decompiled with CFR 0.152.
 */
package cn.lzgabel.layouter;

import cn.lzgabel.layouter.Layouter;
import cn.lzgabel.layouter.SimpleOrthogonalFlowRouter;
import cn.lzgabel.model.bpmn.BPMNUtils;
import cn.lzgabel.model.grid.Cell;
import cn.lzgabel.model.grid.Grid;
import cn.lzgabel.model.grid.GridPosition;
import cn.lzgabel.util.Util;
import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.activiti.bpmn.model.Activity;
import org.activiti.bpmn.model.BoundaryEvent;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.CallActivity;
import org.activiti.bpmn.model.Event;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.FlowNode;
import org.activiti.bpmn.model.GraphicInfo;
import org.activiti.bpmn.model.Lane;
import org.activiti.bpmn.model.Pool;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.bpmn.model.SubProcess;

public class SimpleGridLayouter
extends Layouter {
    public HashMap<String, Grid<FlowNode>> grids = new HashMap();
    public Grid<FlowNode> mainGrid;
    private List<SequenceFlow> containerSpanningFlows = new ArrayList<SequenceFlow>();
    private List<SequenceFlow> temporarySequenceFlows = new ArrayList<SequenceFlow>();
    private HashMap<FlowNode, List<Cell<FlowNode>>> markedCellsMap = new HashMap();
    int cellWidth = 150;
    int cellHeight = (int)((double)this.cellWidth * 0.8);
    int nodeWidth = this.cellWidth * 2 / 3;
    int nodeHeight = (int)((double)this.nodeWidth * 0.8);
    int eventsize = (int)((double)this.cellWidth * 0.24);

    public SimpleGridLayouter(BpmnModel model) {
        super(model);
        this.mainGrid = new Grid();
        this.mainGrid.getColumns().get(0).remove(0);
    }

    public void applyGridToModel() {
        this.mainGrid.setCellsize(this.cellHeight, this.cellWidth);
        this.applyAbsoluteCoordinatesToModel();
        SimpleOrthogonalFlowRouter.routeFlows(this.model);
    }

    public Grid<FlowNode> layoutModelToGrid(boolean moveNodes) throws Exception {
        this.containerSpanningFlows = BPMNUtils.findAndTemporarilyRemoveFlowsBetweenPartitions(this.model.getProcesses(), this.model);
        this.temporarySequenceFlows = BPMNUtils.replaceAssociationsWithSequenceFlows(this.model);
        this.layoutCallActivities();
        this.layoutSubprocesses();
        this.layoutPools();
        this.layoutAndAppendProcessLanes();
        if (this.mainGrid.isEmpty()) {
            this.layoutSingleProcess();
        }
        this.recoverEdgesBetweenPartitions(this.model.getProcesses());
        if (moveNodes) {
            this.moveNodesWithInterleavingEdges();
        }
        BPMNUtils.removeTemporarySequenceFlowsFromModel(this.temporarySequenceFlows, this.model);
        return this.mainGrid;
    }

    public void applyAbsoluteCoordinatesToModel() {
        Point absolutePosition = new Point(0, 0);
        for (List<Cell<FlowNode>> col : this.mainGrid.getColumns()) {
            for (Cell<FlowNode> cell : col) {
                cell.absolutePosition = new Point(absolutePosition);
                if (cell.getValue() != null) {
                    if (cell.getValue() instanceof SubProcess && BPMNUtils.activityIsExpanded(cell.getValue().getId(), this.model)) {
                        this.updateSubprocessGraphicInfo(cell.getValue().getId(), absolutePosition);
                    } else if (cell.getValue() instanceof CallActivity && BPMNUtils.activityIsExpanded(cell.getValue().getId(), this.model)) {
                        this.updateCallActivityGraphicInfo(cell.getValue().getId(), absolutePosition);
                    } else {
                        this.updateElementGraphicInfo(cell.getValue().getId(), absolutePosition);
                    }
                    if (cell.getDocks().size() > 0) {
                        this.updateBoundaryEventGraphicInfo(cell, absolutePosition);
                    }
                }
                absolutePosition.y += this.cellHeight;
            }
            absolutePosition.y = 0;
            absolutePosition.x += this.cellWidth;
        }
        for (Pool pool : this.model.getPools()) {
            this.updatePoolGraphicInfo(pool);
        }
        for (Process process : this.model.getProcesses()) {
            for (Lane lane : process.getLanes()) {
                if (!BPMNUtils.laneIsNotWithinPool(lane, this.model)) continue;
                this.updateLaneGraphicInfo(lane);
            }
        }
    }

    private void addAllExpandedCallActivityProcessesToProcessGridMap(List<Process> processes, FlowElement flowElement) {
        CallActivity callActivity = (CallActivity)flowElement;
        if (BPMNUtils.activityIsExpanded(callActivity.getId(), this.model)) {
            this.addCallActivityProcessToGridMap(processes, callActivity);
        }
    }

    private void addBoundaryEventDock(Grid<FlowNode> grid, BoundaryEvent boundaryEvent) {
        Activity attachedToNode = boundaryEvent.getAttachedToRef();
        grid.getCellByValue((FlowNode)attachedToNode).addDock((FlowNode)boundaryEvent);
    }

    private void addCallActivityProcessToGridMap(List<Process> processes, CallActivity callActivity) {
        String id = callActivity.getCalledElement();
        for (Process callActivityProcess : processes) {
            if (!callActivityProcess.getId().equals(id)) continue;
            this.addProcessToGridMap(callActivityProcess);
        }
    }

    private void addGridToMainGrid(Grid<FlowNode> processGrid) {
        if (!this.mainGrid.isEmpty()) {
            this.mainGrid.addLastRow();
        }
        processGrid.getGridPosition().row = this.mainGrid.getGridSize().rows();
        this.mainGrid.appendGrid(processGrid);
    }

    private void addLanesToGridMap(List<Lane> lanes) {
        for (Lane lane : lanes) {
            List<FlowNode> flowNodes = this.gatherFlowNodesFromLane(lane);
            Grid<FlowNode> laneGrid = this.layoutFlowNodesToGrid(flowNodes);
            this.grids.put(lane.getId(), laneGrid);
        }
    }

    private List<FlowNode> gatherFlowNodesFromLane(Lane lane) {
        List flowReferences = lane.getFlowReferences();
        ArrayList<FlowNode> flowNodes = new ArrayList<FlowNode>();
        for (String ref : flowReferences) {
            FlowElement e = this.model.getFlowElement(ref);
            if (!(e instanceof FlowNode) || e instanceof BoundaryEvent) continue;
            flowNodes.add((FlowNode)e);
        }
        return flowNodes;
    }

    private void addProcessToGridMap(Process process) {
        List<FlowNode> flowNodes = BPMNUtils.getFlowNodesFromFlowElementsList(process.getFlowElements());
        Grid<FlowNode> processGrid = this.layoutFlowNodesToGrid(flowNodes);
        this.grids.put(process.getId(), processGrid);
    }

    private void createAndReserveCellsForSubprocess(SubProcess sp, GridPosition position, Grid<FlowNode> grid) {
        Grid<FlowNode> spGrid = this.grids.get(sp.getId());
        if (spGrid == null) {
            this.addSubprocessGridMap(sp);
            spGrid = this.grids.get(sp.getId());
        }
        int spRows = this.grids.get(sp.getId()).getGridSize().rows();
        if (sp.getBoundaryEvents().size() > 0) {
            --spRows;
            --spRows;
        }
        grid.addRowsBelowAndAbovePosition(position, spRows);
        grid.createAndReserveCells(position, spGrid);
    }

    private void addSubprocessGridMap(SubProcess sp) {
        Collection flowElements = sp.getFlowElements();
        List<FlowNode> flowNodes = BPMNUtils.getFlowNodesFromFlowElementsList(flowElements);
        Grid<FlowNode> subprocessGrid = this.layoutFlowNodesToGrid(flowNodes);
        this.grids.put(sp.getId(), subprocessGrid);
    }

    private void appendLanesToMainGrid(Process process) {
        if (!this.mainGrid.isEmpty()) {
            this.mainGrid.addLastRow();
        }
        for (Lane lane : process.getLanes()) {
            Grid<FlowNode> laneGrid = this.grids.get(lane.getId());
            laneGrid.getGridPosition().row = this.mainGrid.getGridSize().rows();
            this.mainGrid.appendGrid(laneGrid);
        }
    }

    private GridPosition calulateNodePosition(FlowNode node, Grid<FlowNode> grid) {
        GridPosition position = new GridPosition(0, 0);
        Cell<FlowNode> previousCell = null;
        int incomingFlowCount = node.getIncomingFlows().size();
        int outgoingFlowCount = node.getOutgoingFlows().size();
        int boundaryEventCount = BPMNUtils.getBoundaryEventCount(node);
        boolean positionSetByMarker = false;
        if (incomingFlowCount == 0) {
            if (outgoingFlowCount > 1) {
                this.prepareGridForSplit(node, grid, position, outgoingFlowCount);
            }
            if (boundaryEventCount > 0) {
                this.prepareGridForBoundaryEvents(node, grid, position, boundaryEventCount, 1);
            }
            return position;
        }
        previousCell = this.getPreviousCell(node, grid);
        GridPosition previousPosition = this.getPositionOfPreviousCell(grid, previousCell);
        if (previousCell.getValue() instanceof SubProcess) {
            Grid<FlowNode> subprocessGrid = this.grids.get(previousCell.getValue().getId());
            previousPosition.row = (int)((double)previousPosition.row + Math.floor((double)subprocessGrid.getGridSize().rows() / 2.0));
        }
        position = new GridPosition(previousPosition);
        if (this.isCellMarkerForPositionSetByPreviousNode(previousCell)) {
            List<Cell<FlowNode>> markedCells = this.markedCellsMap.get(previousCell.getValue());
            if (this.isfollowingCellAlreadyInGrid(node, grid)) {
                this.calculatePositionOfLoopElement(position, previousCell, markedCells);
            } else {
                position = markedCells.get((int)0).gridPosition;
                markedCells.remove(markedCells.get(0));
            }
            positionSetByMarker = true;
        }
        if (!positionSetByMarker && BPMNUtils.isElementPartOfSequentialSequence(node, previousCell.getValue())) {
            position.column = previousPosition.column + 1;
            if (this.elementIsPartOfLoop(node, grid)) {
                position = this.calculatePositionForLoopElement(grid, position);
            }
        }
        if (outgoingFlowCount > 1) {
            if (positionSetByMarker) {
                --position.column;
                this.prepareGridForSplit(node, grid, position, outgoingFlowCount);
                ++position.column;
            } else if (this.nodeLoopsBack(node, grid)) {
                if (outgoingFlowCount - 1 == 1) {
                    position = this.getPositionOfPreviousCell(grid, previousCell);
                    position.column = previousPosition.column + 1;
                }
            } else {
                this.prepareGridForSplit(node, grid, position, outgoingFlowCount);
                previousCell = this.getPreviousCell(node, grid);
                position = this.getPositionOfPreviousCell(grid, previousCell);
                position.column = previousPosition.column + 1;
            }
        }
        if (incomingFlowCount > 1) {
            int rowSum = 0;
            int prevCellCount = 0;
            for (SequenceFlow e : node.getIncomingFlows()) {
                FlowNode previousNode = (FlowNode)this.model.getFlowElement(e.getSourceRef());
                if (grid.getCellByValue(previousNode) == null) continue;
                rowSum += grid.getCellByValue((FlowNode)previousNode).gridPosition.row;
                ++prevCellCount;
            }
            position.column = previousPosition.column + 1;
            if (prevCellCount > 0) {
                position.row = rowSum <= 2 ? (rowSum % 2 == 0 ? rowSum - 1 : rowSum + 1 / prevCellCount) : rowSum / prevCellCount;
            }
        }
        if (boundaryEventCount > 0) {
            position.column = previousPosition.column + 1;
            while (grid.getCell(position) != null && grid.getCell(position).getValue() != null) {
                ++position.column;
            }
            this.prepareGridForBoundaryEvents(node, grid, position, boundaryEventCount, 2);
        }
        return position;
    }

    private boolean nodeLoopsBack(FlowNode node, Grid<FlowNode> grid) {
        for (SequenceFlow flow : node.getOutgoingFlows()) {
            String targetRef = flow.getTargetRef();
            FlowNode targetNode = (FlowNode)this.model.getFlowElement(targetRef);
            if (grid.getCellByValue(targetNode) == null) continue;
            return true;
        }
        return false;
    }

    private void prepareGridForBoundaryEvents(FlowNode node, Grid<FlowNode> grid, GridPosition position, int boundaryEventCount, int colCount) {
        for (int colCounter = 0; colCounter < colCount; ++colCounter) {
            if (grid.getColumns().size() >= position.column + colCounter + 2) continue;
            grid.addColumn();
        }
        this.markCellsForBoundaryEvents(node, position, boundaryEventCount, grid);
    }

    private void markCellsForBoundaryEvents(FlowNode node, GridPosition position, int boundaryEventCount, Grid<FlowNode> grid) {
        ArrayList<Cell<FlowNode>> markedCells = new ArrayList<Cell<FlowNode>>();
        this.markedCellsMap.put(node, markedCells);
        for (int i = 0; i < boundaryEventCount; ++i) {
            GridPosition markedCellPosition = new GridPosition(position.row + i + 1, position.column + 1);
            if (node instanceof SubProcess && this.grids.get(node.getId()) != null) {
                int subprocessRows = this.grids.get(node.getId()).getGridSize().rows();
                int subprocessColumns = this.grids.get(node.getId()).getGridSize().columns();
                markedCellPosition.row += subprocessRows - 1;
                markedCellPosition.column += subprocessColumns - 1;
            }
            while (grid.getGridSize().rows() < markedCellPosition.row + 1) {
                grid.addRowBelow(position.row + i);
            }
            while (grid.getGridSize().columns() < markedCellPosition.column + 1) {
                grid.addColumn();
            }
            Cell<FlowNode> markedCell = grid.getCell(markedCellPosition);
            markedCells.add(0, markedCell);
        }
    }

    private void calculatePositionOfLoopElement(GridPosition position, Cell<FlowNode> previousCell, List<Cell<FlowNode>> markedCells) {
        int loopColumn = (previousCell.gridPosition.column + (position.column - 1)) / 2;
        position.row = markedCells.get((int)0).gridPosition.row;
        position.column = loopColumn - 1;
        this.shrinkMarkedRows(previousCell.getValue());
    }

    private boolean isfollowingCellAlreadyInGrid(FlowNode node, Grid<FlowNode> grid) {
        for (SequenceFlow outgoing : node.getOutgoingFlows()) {
            FlowNode targetNode = (FlowNode)this.model.getFlowElement(outgoing.getTargetRef());
            if (grid.getCellByValue(targetNode) == null) continue;
            return true;
        }
        return false;
    }

    private boolean isCellMarkerForPositionSetByPreviousNode(Cell<FlowNode> previousCell) {
        return this.markedCellsMap.get(previousCell.getValue()) != null && !this.markedCellsMap.get(previousCell.getValue()).isEmpty();
    }

    private void prepareGridForSplit(FlowNode node, Grid<FlowNode> grid, GridPosition position, int outgoingFlowSize) {
        if (grid.getColumns().size() <= position.column + 2) {
            grid.addColumn();
            grid.addColumn();
        }
        this.markCellsForSplit(node, position, outgoingFlowSize, grid);
    }

    private boolean elementIsPartOfLoop(FlowNode node, Grid<FlowNode> grid) {
        Cell<FlowNode> subsequentCell;
        int outgoingFlowSize = BPMNUtils.getBoundaryEventCount(node);
        return outgoingFlowSize == 1 && (subsequentCell = this.getSubsequentCell(node, grid)) != null && subsequentCell.getValue() != null;
    }

    private GridPosition calculatePositionForLoopElement(Grid<FlowNode> grid, GridPosition position) {
        GridPosition preferedPosition = new GridPosition(position);
        preferedPosition.column -= 2;
        if (grid.getCell(preferedPosition).getValue() == null) {
            position = preferedPosition;
        } else {
            grid.addRowAbove(position.column);
            --position.row;
            --position.column;
        }
        return position;
    }

    private Cell<FlowNode> getSubsequentCell(FlowNode node, Grid<FlowNode> grid) {
        FlowNode firstTargetNode = BPMNUtils.getSubsequentNode(node, this.model);
        Cell<FlowNode> targetCell = grid.getCellByValue(firstTargetNode);
        return targetCell;
    }

    private Cell<FlowNode> getPreviousCell(FlowNode node, Grid<FlowNode> grid) {
        FlowNode previousFlowNode = this.getRightMostFlowNode(node.getIncomingFlows(), grid);
        if (previousFlowNode instanceof BoundaryEvent) {
            BoundaryEvent be = (BoundaryEvent)previousFlowNode;
            previousFlowNode = be.getAttachedToRef();
        }
        Cell<FlowNode> previousCell = grid.getCellByValue(previousFlowNode);
        return previousCell;
    }

    private GridPosition getPositionOfPreviousCell(Grid<FlowNode> grid, Cell<FlowNode> previousCell) {
        GridPosition position = new GridPosition();
        if (previousCell != null) {
            if (previousCell.getValue() instanceof SubProcess || previousCell.getValue() instanceof CallActivity) {
                Activity activity = (Activity)previousCell.getValue();
                position = previousCell.gridPosition.clone();
                if (BPMNUtils.activityIsExpanded(activity.getId(), this.model)) {
                    if (previousCell.getValue() instanceof CallActivity) {
                        position.column += this.grids.get(((CallActivity)activity).getCalledElement()).getGridSize().columns() - 1;
                    } else if (previousCell.getValue() instanceof SubProcess) {
                        position.column += this.grids.get(activity.getId()).getGridSize().columns() - 1;
                    }
                }
            } else {
                position = previousCell.gridPosition.clone();
            }
        } else {
            position.column = grid.getColumns().size() - 1;
        }
        return position;
    }

    private FlowNode getRightMostFlowNode(List<SequenceFlow> incomingFlows, Grid<FlowNode> grid) {
        FlowNode rightMostNode = (FlowNode)this.model.getFlowElement(incomingFlows.iterator().next().getSourceRef());
        int rightMostColumn = 0;
        if (rightMostNode instanceof BoundaryEvent) {
            BoundaryEvent be = (BoundaryEvent)rightMostNode;
            Activity attachedTo = be.getAttachedToRef();
            rightMostColumn = grid.getCellByValue((FlowNode)attachedTo).gridPosition.column;
        } else {
            rightMostColumn = grid.getCellByValue((FlowNode)rightMostNode).gridPosition.column;
        }
        for (SequenceFlow flow : incomingFlows) {
            Grid<FlowNode> caGrid;
            CallActivity callActivity;
            GraphicInfo gi;
            Grid<FlowNode> spGrid;
            GraphicInfo gi2;
            Cell<FlowNode> cell;
            FlowNode node = (FlowNode)this.model.getFlowElement(flow.getSourceRef());
            if (node instanceof BoundaryEvent) {
                BoundaryEvent be = (BoundaryEvent)node;
                node = be.getAttachedToRef();
            }
            if ((cell = grid.getCellByValue(node)) == null) continue;
            if (cell.gridPosition.column > rightMostColumn) {
                rightMostNode = node;
                rightMostColumn = cell.gridPosition.column;
            }
            if (node instanceof SubProcess && (gi2 = this.model.getGraphicInfo(node.getId())).getExpanded() != null && gi2.getExpanded().booleanValue() && cell.gridPosition.column + (spGrid = this.grids.get(node.getId())).getGridSize().columns() > rightMostColumn) {
                rightMostNode = node;
                rightMostColumn = cell.gridPosition.column + spGrid.getGridSize().columns();
            }
            if (!(node instanceof CallActivity) || (gi = this.model.getGraphicInfo((callActivity = (CallActivity)node).getId())).getExpanded() == null || !gi.getExpanded().booleanValue() || cell.gridPosition.column + (caGrid = this.grids.get(callActivity.getCalledElement())).getGridSize().columns() <= rightMostColumn) continue;
            rightMostNode = node;
            rightMostColumn = cell.gridPosition.column + caGrid.getGridSize().columns();
        }
        return rightMostNode;
    }

    private void layoutAndAppendProcessLanes() {
        for (Process process : this.model.getProcesses()) {
            if (process.getLanes().size() == 0 || BPMNUtils.isProcessInPool(process, this.model)) continue;
            this.addLanesToGridMap(process.getLanes());
            this.appendLanesToMainGrid(process);
        }
    }

    private void layoutCallActivities() {
        for (Process process : this.model.getProcesses()) {
            for (FlowElement callActivity : process.findFlowElementsOfType(CallActivity.class)) {
                this.addAllExpandedCallActivityProcessesToProcessGridMap(this.model.getProcesses(), callActivity);
            }
        }
    }

    private Grid<FlowNode> layoutFlowNodesToGrid(List<FlowNode> flowNodes) {
        Grid<FlowNode> grid = new Grid<FlowNode>();
        List<FlowNode> sortedList = Util.topologicalSortNodes(flowNodes, this.model);
        for (FlowNode node : sortedList) {
            if (node instanceof BoundaryEvent) {
                this.addBoundaryEventDock(grid, (BoundaryEvent)node);
                continue;
            }
            GridPosition position = this.calulateNodePosition(node, grid);
            if (node instanceof SubProcess && BPMNUtils.activityIsExpanded(node.getId(), this.model)) {
                this.createAndReserveCellsForSubprocess((SubProcess)node, position, grid);
            }
            grid.addValue(node, position);
            GridPosition actualPosition = grid.getCellByValue((FlowNode)node).gridPosition;
            if (actualPosition.equals(position) || !this.markedCellsMap.containsKey(node)) continue;
            int columnDifference = actualPosition.column - position.column;
            ArrayList<Cell<FlowNode>> newMarkedCellList = new ArrayList<Cell<FlowNode>>();
            for (Cell<FlowNode> cell : this.markedCellsMap.get(node)) {
                GridPosition cellPosition = cell.gridPosition;
                cellPosition.column += columnDifference;
                newMarkedCellList.add(grid.getCell(cellPosition));
            }
            this.markedCellsMap.put(node, newMarkedCellList);
        }
        return grid;
    }

    private void layoutPools() {
        for (Pool pool : this.model.getPools()) {
            Process process = this.model.getProcess(pool.getId());
            if (process == null) {
                this.addClosedPoolToGridMap(pool.getId());
                this.addGridToMainGrid(this.grids.get(pool.getId()));
                continue;
            }
            if (process.getLanes().size() == 0) {
                this.addProcessToGridMap(process);
                this.addGridToMainGrid(this.grids.get(process.getId()));
                continue;
            }
            this.addLanesToGridMap(process.getLanes());
            this.appendLanesToMainGrid(process);
        }
    }

    private void addClosedPoolToGridMap(String poolId) {
        Grid poolGrid = new Grid();
        this.grids.put(poolId, poolGrid);
    }

    private void layoutSingleProcess() {
        for (Process process : this.model.getProcesses()) {
            if (this.grids.containsKey(process.getId())) continue;
            this.addProcessToGridMap(process);
            this.addGridToMainGrid(this.grids.get(process.getId()));
        }
    }

    private void layoutSubprocesses() {
        for (Process process : this.model.getProcesses()) {
            for (SubProcess subprocess : process.findFlowElementsOfType(SubProcess.class)) {
                if (!BPMNUtils.activityIsExpanded(subprocess.getId(), this.model)) continue;
                this.addSubprocessGridMap(subprocess);
            }
        }
    }

    private void markCellsForSplit(FlowNode node, GridPosition position, int size, Grid<FlowNode> grid) {
        ArrayList<Cell<FlowNode>> markedCells = new ArrayList<Cell<FlowNode>>();
        this.markedCellsMap.put(node, markedCells);
        if (size > 2) {
            Cell<FlowNode> upperCell;
            GridPosition upperCellPosition;
            int row;
            int relativeYPosition;
            int indexOfCurrentShape;
            int numberOfShapesInTheSplit;
            int i;
            for (i = size / 2 + 1; i < size; ++i) {
                numberOfShapesInTheSplit = size;
                indexOfCurrentShape = i - 1;
                relativeYPosition = indexOfCurrentShape - numberOfShapesInTheSplit / 2;
                row = position.row + relativeYPosition;
                upperCellPosition = new GridPosition(row, position.column + 2);
                grid.addRowAbove(row);
                upperCell = grid.getCell(upperCellPosition);
                assert (upperCell != null);
                markedCells.add(upperCell);
            }
            for (i = size / 2; i >= 0; --i) {
                numberOfShapesInTheSplit = size;
                indexOfCurrentShape = i + 1;
                if (size % 2 != 0) {
                    indexOfCurrentShape = i;
                }
                relativeYPosition = indexOfCurrentShape - numberOfShapesInTheSplit / 2;
                row = position.row + size / 2 - relativeYPosition;
                upperCellPosition = new GridPosition(row, position.column + 2);
                grid.addRowBelow(row);
                upperCell = grid.getCell(upperCellPosition);
                assert (upperCell != null);
                markedCells.add(upperCell);
            }
        } else if (size <= 2) {
            int currentRow = position.row;
            GridPosition upperCellPosition = new GridPosition(currentRow - 1, position.column + 2);
            while (grid.getCell(upperCellPosition) == null || grid.getCell(upperCellPosition).getValue() != null) {
                grid.addRowAbove(currentRow);
                upperCellPosition = new GridPosition(++currentRow - 1, position.column + 2);
            }
            Cell<FlowNode> upperCell = grid.getCell(upperCellPosition);
            assert (upperCell != null);
            markedCells.add(upperCell);
            GridPosition lowerCellPosition = new GridPosition(currentRow + 1, position.column + 2);
            while (grid.getCell(lowerCellPosition) == null || grid.getCell(lowerCellPosition).getValue() != null) {
                grid.addRowBelow(currentRow);
            }
            Cell<FlowNode> lowerCell = grid.getCell(lowerCellPosition);
            assert (lowerCell != null);
            markedCells.add(lowerCell);
        }
    }

    private void moveNodes(FlowNode startingFlowNode, int distance, Direction dir) throws Exception {
        switch (dir) {
            case RIGHT: {
                List<FlowNode> nodesPreparedForMove = BPMNUtils.findAllSubsequentFlowNodesInGroup(startingFlowNode, this.model);
                Collections.reverse(nodesPreparedForMove);
                for (FlowNode node : nodesPreparedForMove) {
                    try {
                        this.mainGrid.shiftFlowNode(node, distance);
                    }
                    catch (ArrayIndexOutOfBoundsException E) {
                        System.out.println("Node can't be moved");
                        System.out.println("Name:\t\t" + node.getName());
                        System.out.println("Dist:\t\t" + distance);
                        throw new Exception();
                    }
                }
                break;
            }
            default: {
                return;
            }
        }
    }

    private void moveNodesWithInterleavingEdges() throws Exception {
        int distance;
        Cell<FlowNode> trgCell;
        Cell<FlowNode> srcCell;
        FlowNode target;
        FlowNode source;
        for (SequenceFlow flow : this.containerSpanningFlows) {
            source = (FlowNode)this.model.getFlowElement(flow.getSourceRef());
            target = (FlowNode)this.model.getFlowElement(flow.getTargetRef());
            srcCell = this.mainGrid.getCellByValue(source);
            trgCell = this.mainGrid.getCellByValue(target);
            distance = this.mainGrid.getColumnOf(srcCell) - this.mainGrid.getColumnOf(trgCell);
            if (distance == 0) continue;
            try {
                this.moveNodes(target, distance, Direction.RIGHT);
            }
            catch (Exception e) {
                throw new Exception();
            }
        }
        for (SequenceFlow flow : this.model.getMessageFlows().values()) {
            source = (FlowNode)this.model.getFlowElement(flow.getSourceRef());
            target = (FlowNode)this.model.getFlowElement(flow.getTargetRef());
            srcCell = this.mainGrid.getCellByValue(source);
            trgCell = this.mainGrid.getCellByValue(target);
            distance = this.mainGrid.getColumnOf(srcCell) - this.mainGrid.getColumnOf(trgCell);
            if (distance <= 0 || this.model.getPool(flow.getSourceRef()) != null || this.model.getPool(flow.getTargetRef()) != null) continue;
            try {
                this.moveNodes(target, distance, Direction.RIGHT);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new Exception();
            }
        }
    }

    private void recoverEdgesBetweenPartitions(List<Process> processes) {
        for (SequenceFlow flow : this.containerSpanningFlows) {
            FlowNode source = (FlowNode)this.model.getFlowElement(flow.getSourceRef());
            FlowNode target = (FlowNode)this.model.getFlowElement(flow.getTargetRef());
            source.getOutgoingFlows().add(flow);
            target.getIncomingFlows().add(flow);
        }
    }

    private void shrinkMarkedRows(FlowNode node) {
        List<Cell<FlowNode>> markedRows = this.markedCellsMap.get(node);
        if (markedRows.size() == 2) {
            markedRows.clear();
        }
    }

    private void updateBoundaryEventGraphicInfo(Cell<FlowNode> cell, Point absolutePosition) {
        int x = absolutePosition.x;
        int y = absolutePosition.y;
        int spGridModifierX = 0;
        int spGridModifierY = 0;
        if (cell.getValue() instanceof SubProcess && BPMNUtils.activityIsExpanded(cell.getValue().getId(), this.model)) {
            Grid<FlowNode> subprocessGrid = this.grids.get(cell.getValue().getId());
            spGridModifierX = subprocessGrid.getAbsoluteSize().width - this.cellWidth;
            spGridModifierY = subprocessGrid.getAbsoluteSize().height - this.cellHeight + (int)((double)this.eventsize * 0.5);
        }
        for (int i = 0; i < cell.getDocks().size(); ++i) {
            FlowNode dock = cell.getDocks().get(i);
            dock.setName("");
            GraphicInfo gi = this.model.getGraphicInfo(dock.getId());
            switch (i) {
                case 0: {
                    x = (int)((double)absolutePosition.x + (double)this.cellWidth * 0.4) + spGridModifierX;
                    y = (int)((double)absolutePosition.y + (double)this.cellHeight * 0.65) + spGridModifierY;
                    cell.setAbsolutePositionOfDock(dock, new Point(x, y));
                    break;
                }
                case 1: {
                    x = (int)((double)absolutePosition.x + (double)this.cellWidth * 0.6) + spGridModifierX;
                    y = (int)((double)absolutePosition.y + (double)this.cellHeight * 0.65) + spGridModifierY;
                    cell.setAbsolutePositionOfDock(dock, new Point(x, y));
                    break;
                }
                case 2: {
                    break;
                }
            }
            gi.setX((double)x);
            gi.setY((double)y);
            gi.setWidth((double)this.eventsize);
            gi.setHeight((double)this.eventsize);
        }
    }

    private void updateCallActivityGraphicInfo(String id, Point absolutePosition) {
        GraphicInfo caGraphicInfo = this.model.getGraphicInfo(id);
        CallActivity callActivity = (CallActivity)this.model.getFlowElement(id);
        if (callActivity.getCalledElement() == null || caGraphicInfo.getExpanded() == null || !caGraphicInfo.getExpanded().booleanValue()) {
            int xMargin = (this.cellWidth - this.nodeWidth) / 2;
            int yMargin = (this.cellHeight - this.nodeHeight) / 2;
            caGraphicInfo.setX((double)(absolutePosition.x + xMargin));
            caGraphicInfo.setY((double)(absolutePosition.y + yMargin));
            caGraphicInfo.setWidth((double)this.nodeWidth);
            caGraphicInfo.setHeight((double)this.nodeHeight);
            return;
        }
        Grid<FlowNode> processGrid = this.grids.get(callActivity.getCalledElement());
        processGrid.setCellsize(this.cellHeight, this.cellWidth);
        caGraphicInfo.setX((double)absolutePosition.x);
        caGraphicInfo.setY((double)absolutePosition.y + processGrid.getAbsoluteSize().getHeight() * 0.05);
        caGraphicInfo.setWidth(processGrid.getAbsoluteSize().getWidth());
        caGraphicInfo.setHeight(processGrid.getAbsoluteSize().getHeight() * 0.9);
        Point processElementPosition = new Point(absolutePosition);
        for (List<Cell<FlowNode>> col : processGrid.getColumns()) {
            for (Cell<FlowNode> cell : col) {
                cell.absolutePosition = new Point(processElementPosition);
                if (cell.getValue() != null) {
                    this.updateElementGraphicInfo(cell.getValue().getId(), processElementPosition);
                    if (cell.getDocks().size() > 0) {
                        this.updateBoundaryEventGraphicInfo(cell, processElementPosition);
                    }
                }
                processElementPosition.y += this.cellHeight;
            }
            processElementPosition.y = absolutePosition.y;
            processElementPosition.x += this.cellWidth;
        }
    }

    private void updateElementGraphicInfo(String key, Point absolutePosition) {
        GraphicInfo elementGraphicInfo = this.model.getGraphicInfo(key);
        if (this.model.getFlowElement(key) instanceof Activity) {
            elementGraphicInfo.setWidth((double)this.nodeWidth);
            elementGraphicInfo.setHeight((double)this.nodeWidth * 0.8);
        }
        if (this.model.getFlowElement(key) instanceof Event) {
            elementGraphicInfo.setWidth((double)this.eventsize);
            elementGraphicInfo.setHeight((double)this.eventsize);
        }
        int xMargin = (int)(((double)this.cellWidth - elementGraphicInfo.getWidth()) / 2.0);
        int yMargin = (int)(((double)this.cellHeight - elementGraphicInfo.getHeight()) / 2.0);
        elementGraphicInfo.setX((double)(absolutePosition.x + xMargin));
        elementGraphicInfo.setY((double)(absolutePosition.y + yMargin));
    }

    private void updateLaneGraphicInfo(Lane lane) {
        String laneId = lane.getId();
        Grid<FlowNode> laneGrid = this.grids.get(laneId);
        laneGrid.setCellsize(this.cellHeight, this.cellWidth);
        GraphicInfo flowNodeGraphicInfo = this.model.getGraphicInfo(lane.getId());
        flowNodeGraphicInfo.setX((double)laneGrid.getAbsolutePosition().x);
        flowNodeGraphicInfo.setY((double)laneGrid.getAbsolutePosition().y);
        flowNodeGraphicInfo.setWidth(this.mainGrid.getAbsoluteSize().getWidth());
        flowNodeGraphicInfo.setHeight(laneGrid.getAbsoluteSize().getHeight());
    }

    private void updateLaneWithinPoolGraphicInfo(Lane lane) {
        String laneId = lane.getId();
        Grid<FlowNode> laneGrid = this.grids.get(laneId);
        laneGrid.setCellsize(this.cellHeight, this.cellWidth);
        int offset = 30;
        GraphicInfo flowNodeGraphicInfo = this.model.getGraphicInfo(lane.getId());
        flowNodeGraphicInfo.setX((double)(laneGrid.getAbsolutePosition().x + offset));
        flowNodeGraphicInfo.setY((double)laneGrid.getAbsolutePosition().y);
        flowNodeGraphicInfo.setWidth(this.mainGrid.getAbsoluteSize().getWidth() - (double)offset);
        flowNodeGraphicInfo.setHeight(laneGrid.getAbsoluteSize().getHeight());
    }

    private void updatePoolGraphicInfo(Pool pool) {
        String processRef = pool.getProcessRef();
        Grid<FlowNode> poolGrid = this.grids.get(processRef);
        if (poolGrid == null) {
            poolGrid = this.grids.get(pool.getId());
        }
        if (poolGrid == null) {
            Process process = BPMNUtils.getProcessFromModel(processRef, this.model);
            if (process != null && process.getLanes().size() > 0) {
                Point position = null;
                Dimension size = new Dimension();
                for (Lane lane : BPMNUtils.getProcessFromModel(processRef, this.model).getLanes()) {
                    Grid<FlowNode> laneGrid = this.grids.get(lane.getId());
                    this.updateLaneGraphicInfo(lane);
                    if (position == null || laneGrid.getAbsolutePosition().y < position.y) {
                        position = laneGrid.getAbsolutePosition();
                    }
                    size.height = (int)((double)size.height + laneGrid.getAbsoluteSize().getHeight());
                    this.updateLaneWithinPoolGraphicInfo(lane);
                }
                GraphicInfo poolGraphicInfo = this.model.getGraphicInfo(pool.getId());
                poolGraphicInfo.setX((double)position.x);
                poolGraphicInfo.setY((double)position.y);
                poolGraphicInfo.setWidth(this.mainGrid.getAbsoluteSize().getWidth());
                poolGraphicInfo.setHeight(size.getHeight());
            }
            return;
        }
        poolGrid.setCellsize(this.cellHeight, this.cellWidth);
        GraphicInfo poolGraphicInfo = this.model.getGraphicInfo(pool.getId());
        poolGraphicInfo.setX((double)poolGrid.getAbsolutePosition().x);
        poolGraphicInfo.setY((double)poolGrid.getAbsolutePosition().y);
        poolGraphicInfo.setWidth(this.mainGrid.getAbsoluteSize().getWidth());
        poolGraphicInfo.setHeight(poolGrid.getAbsoluteSize().getHeight());
    }

    private void updateSubprocessGraphicInfo(String subprocessId, Point absolutePosition) {
        GraphicInfo flowNodeGraphicInfo = this.model.getGraphicInfo(subprocessId);
        Grid<FlowNode> spGrid = this.grids.get(subprocessId);
        spGrid.setCellsize(this.cellHeight, this.cellWidth);
        if (this.subprocessIsEmpty(subprocessId)) {
            this.updateElementGraphicInfo(subprocessId, absolutePosition);
            return;
        }
        flowNodeGraphicInfo.setX((double)absolutePosition.x);
        flowNodeGraphicInfo.setY((double)absolutePosition.y - spGrid.getAbsoluteSize().getHeight() / 3.0);
        flowNodeGraphicInfo.setWidth(spGrid.getAbsoluteSize().getWidth());
        flowNodeGraphicInfo.setHeight(spGrid.getAbsoluteSize().getHeight() * 1.67);
        Point spElementPosition = new Point(absolutePosition);
        for (List<Cell<FlowNode>> col : spGrid.getColumns()) {
            for (Cell<FlowNode> cell : col) {
                cell.absolutePosition = new Point(spElementPosition);
                if (cell.getValue() != null) {
                    this.updateElementGraphicInfo(cell.getValue().getId(), spElementPosition);
                    if (cell.getDocks().size() > 0) {
                        this.updateBoundaryEventGraphicInfo(cell, spElementPosition);
                    }
                }
                spElementPosition.y += this.cellHeight;
            }
            spElementPosition.y = absolutePosition.y;
            spElementPosition.x += this.cellWidth;
        }
    }

    private boolean subprocessIsEmpty(String subprocessId) {
        if (this.grids.get(subprocessId).getColumns().size() > 1) {
            return false;
        }
        return this.grids.get(subprocessId).getCell(new GridPosition(0, 0)).getValue() == null;
    }

    private static enum Direction {
        DOWN,
        LEFT,
        RIGHT,
        UP;

    }
}

