/*
 * Decompiled with CFR 0.152.
 */
package cn.lzgabel;

import cn.lzgabel.layouter.SimpleGridLayouter;
import cn.lzgabel.util.Util;
import java.io.File;
import java.util.HashMap;
import org.activiti.bpmn.model.BpmnModel;
import org.apache.commons.io.FileUtils;
import org.jdom2.Element;

public class App {
    private static boolean move = false;

    public static void main(String[] args) throws Exception {
        String filename = "";
        filename = "A.1.0";
        for (String arg : args) {
            if (!arg.equals("-move")) continue;
            move = true;
        }
        if (args.length > 0) {
            App.layoutFiles(args);
        } else {
            App.layoutFile(filename);
        }
    }

    private static void layoutFiles(String[] files) throws Exception {
        for (String file : files) {
            App.layoutFile(file);
        }
    }

    static void layoutFile(String filename) throws Exception {
        String filePath = "res/" + filename + ".bpmn";
        File file = new File(filePath);
        File copy = new File(filePath + "copy");
        FileUtils.copyFile((File)file, (File)copy);
        HashMap<String, Element> extensionMap = Util.removeAndGetElementsFromXML(filePath + "copy", "extensionElements");
        BpmnModel model = Util.readBPMFile(copy);
        SimpleGridLayouter layouter = new SimpleGridLayouter(model);
        try {
            layouter.layoutModelToGrid(move);
        }
        catch (Exception e) {
            layouter = new SimpleGridLayouter(model);
            layouter.layoutModelToGrid(false);
        }
        layouter.applyGridToModel();
        String name = "target/" + filename + "_layout.bpmn";
        Util.writeModel(model, name);
        Util.addXMLElementsBackToFile(extensionMap, name);
        copy.delete();
    }
}

