/*
 * Decompiled with CFR 0.152.
 */
package com.relaxed.common.xss.toolkit;

import cn.hutool.core.util.StrUtil;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.safety.Safelist;

public final class HtmlKit {
    private static final Safelist WHITELIST = Safelist.relaxed();

    private HtmlKit() {
    }

    public static String toText(String html, boolean mergeLineBreak) {
        if (StrUtil.isBlank((CharSequence)html)) {
            return html;
        }
        Document document = Jsoup.parse((String)html);
        document.outputSettings(new Document.OutputSettings().prettyPrint(true));
        String result = document.wholeText();
        if (mergeLineBreak) {
            int oldLength;
            do {
                oldLength = result.length();
                result = result.replace('\r', '\n');
            } while ((result = result.replace("\n\n", "\n")).length() != oldLength);
        }
        return result;
    }

    public static String toText(String html) {
        return HtmlKit.toText(html, true);
    }

    public static String cleanUnSafe(String bodyHtml) {
        return HtmlKit.cleanUnSafe(bodyHtml, WHITELIST);
    }

    public static String cleanUnSafe(String bodyHtml, Safelist whitelist) {
        return Jsoup.clean((String)bodyHtml, (String)"", (Safelist)whitelist, (Document.OutputSettings)new Document.OutputSettings().prettyPrint(false));
    }

    static {
        WHITELIST.addAttributes(":all", new String[]{"style", "class"});
        WHITELIST.addAttributes("a", new String[]{"target"});
        WHITELIST.addProtocols("img", "src", new String[]{"data"});
    }
}

