/*
 * Decompiled with CFR 0.152.
 */
package com.relaxed.common.xss.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.relaxed.common.core.util.WebUtils;
import com.relaxed.common.xss.config.XssProperties;
import com.relaxed.common.xss.toolkit.HtmlKit;
import java.io.IOException;

public class XssStringJsonSerializer
extends JsonSerializer<String> {
    private final XssProperties xssProperties;

    public Class<String> handledType() {
        return String.class;
    }

    public void serialize(String value, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (value != null) {
            if (!this.xssProperties.shouldNotFilter(WebUtils.getRequest())) {
                value = HtmlKit.cleanUnSafe(value);
            }
            jsonGenerator.writeString(value);
        }
    }

    public XssStringJsonSerializer(XssProperties xssProperties) {
        this.xssProperties = xssProperties;
    }
}

