/*
 * Decompiled with CFR 0.152.
 */
package com.relaxed.common.xss.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.relaxed.common.core.util.WebUtils;
import com.relaxed.common.xss.config.XssProperties;
import com.relaxed.common.xss.toolkit.HtmlKit;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XssStringJsonDeserializer
extends JsonDeserializer<String> {
    private static final Logger log = LoggerFactory.getLogger(XssStringJsonDeserializer.class);
    private final XssProperties xssProperties;

    public String deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        String value = p.getValueAsString();
        if (this.xssProperties.shouldNotFilter(WebUtils.getRequest())) {
            return value;
        }
        return value != null ? HtmlKit.cleanUnSafe(value) : null;
    }

    public Class<String> handledType() {
        return String.class;
    }

    public XssStringJsonDeserializer(XssProperties xssProperties) {
        this.xssProperties = xssProperties;
    }
}

