/*
 * Decompiled with CFR 0.152.
 */
package com.relaxed.autoconfigure.web.servlet;

import com.relaxed.autoconfigure.web.config.RelaxedWebProperties;
import com.relaxed.autoconfigure.web.filter.TraceIdFilter;
import com.relaxed.autoconfigure.web.servlet.PageParamArgumentResolver;
import java.util.List;
import javax.servlet.Filter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@EnableConfigurationProperties(value={RelaxedWebProperties.class})
@Configuration
public class WebMvcAutoConfiguration {
    private final RelaxedWebProperties webProperties;

    @Bean
    @ConditionalOnMissingBean
    public PageParamArgumentResolver pageParamArgumentResolver() {
        return new PageParamArgumentResolver(this.webProperties.getPageSizeLimit());
    }

    @Bean
    public FilterRegistrationBean<TraceIdFilter> traceIdFilterRegistrationBean() {
        FilterRegistrationBean registrationBean = new FilterRegistrationBean((Filter)new TraceIdFilter(), new ServletRegistrationBean[0]);
        registrationBean.setOrder(Integer.MIN_VALUE);
        return registrationBean;
    }

    public WebMvcAutoConfiguration(RelaxedWebProperties webProperties) {
        this.webProperties = webProperties;
    }

    @Configuration(proxyBeanMethods=false)
    static class CustomWebMvcConfigurer
    implements WebMvcConfigurer {
        private final PageParamArgumentResolver pageParamArgumentResolver;

        public void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
            argumentResolvers.add(this.pageParamArgumentResolver);
        }

        public CustomWebMvcConfigurer(PageParamArgumentResolver pageParamArgumentResolver) {
            this.pageParamArgumentResolver = pageParamArgumentResolver;
        }
    }
}

