/*
 * Decompiled with CFR 0.152.
 */
package com.relaxed.autoconfigure.web.servlet;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.relaxed.common.model.domain.PageParam;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.beans.PropertyValue;
import org.springframework.core.MethodParameter;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.ObjectError;
import org.springframework.validation.annotation.ValidationAnnotationUtils;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.ServletRequestParameterPropertyValues;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class PageParamArgumentResolver
implements HandlerMethodArgumentResolver {
    private static final Logger log = LoggerFactory.getLogger(PageParamArgumentResolver.class);
    private static final Set<String> SQL_KEYWORDS = CollectionUtil.newHashSet((Object[])new String[]{"master", "truncate", "insert", "select", "delete", "update", "declare", "alter", "drop", "sleep"});
    private static final String ASC = "asc";
    private final int pageSizeLimit;

    public PageParamArgumentResolver() {
        this(0);
    }

    public PageParamArgumentResolver(int pageSizeLimit) {
        this.pageSizeLimit = pageSizeLimit;
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return PageParam.class.isAssignableFrom(parameter.getParameterType());
    }

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        PageParam pageParam;
        HttpServletRequest request = (HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class);
        try {
            pageParam = (PageParam)parameter.getParameterType().newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            pageParam = new PageParam();
        }
        BeanWrapper pageParamBeanWrapper = PropertyAccessorFactory.forBeanPropertyAccess((Object)pageParam);
        pageParamBeanWrapper.setExtractOldValueForEditor(true);
        pageParamBeanWrapper.setAutoGrowNestedPaths(true);
        pageParamBeanWrapper.setAutoGrowCollectionLimit(256);
        WebDataBinder binder = null;
        if (binderFactory != null) {
            binder = binderFactory.createBinder(webRequest, (Object)pageParam, "pageParam");
            this.validateIfApplicable(binder, parameter);
            pageParamBeanWrapper.setConversionService(binder.getConversionService());
        }
        ServletRequestParameterPropertyValues pvs = new ServletRequestParameterPropertyValues((ServletRequest)request);
        ArrayList<PropertyValue> pageParamPropertyValues = new ArrayList<PropertyValue>();
        List<PropertyValue> propertyValues = pvs instanceof MutablePropertyValues ? pvs.getPropertyValueList() : Arrays.asList(pvs.getPropertyValues());
        for (PropertyValue pv : propertyValues) {
            String name = pv.getName();
            if (name.equals("current") || name.equals("size")) {
                pageParamPropertyValues.add(pv);
                continue;
            }
            if (!name.startsWith("sort")) continue;
            String value = (String)pv.getValue();
            if (StrUtil.isEmpty((CharSequence)name) || StrUtil.isEmpty((CharSequence)value)) continue;
            pageParamPropertyValues.add(new PropertyValue(name, (Object)ASC.equalsIgnoreCase(value)));
        }
        for (PropertyValue pageParamPropertyValue : pageParamPropertyValues) {
            pageParamBeanWrapper.setPropertyValue(pageParamPropertyValue);
        }
        pageParam.setSort(this.convertToTargetFieldMap(pageParam));
        if (binder != null) {
            this.paramValidate(parameter, mavContainer, webRequest, binder, pageParam);
        }
        return pageParam;
    }

    private Map<String, Boolean> convertToTargetFieldMap(PageParam pageParam) {
        Map sortFieldMap = pageParam.getSort();
        HashMap<String, Boolean> targetFieldMap = new HashMap<String, Boolean>();
        Set sourceSortFieldEntry = sortFieldMap.entrySet();
        for (Map.Entry entry : sourceSortFieldEntry) {
            String field = (String)entry.getKey();
            Boolean value = (Boolean)entry.getValue();
            if (!this.validFieldName(field)) continue;
            targetFieldMap.put(StrUtil.toUnderlineCase((CharSequence)field), value);
        }
        return targetFieldMap;
    }

    public boolean validFieldName(String filedName) {
        boolean isValid;
        boolean bl = isValid = StrUtil.isNotBlank((CharSequence)filedName) && filedName.matches("(([A-Za-z0-9_]{1,10}.)?[A-Za-z0-9_]{1,64})") && !SQL_KEYWORDS.contains(filedName);
        if (!isValid) {
            log.warn("\u5f02\u5e38\u7684\u5206\u9875\u67e5\u8be2\u6392\u5e8f\u5b57\u6bb5\uff1a{}", (Object)filedName);
        }
        return isValid;
    }

    protected void paramValidate(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinder binder, PageParam pageParam) throws Exception {
        BindingResult bindingResult = binder.getBindingResult();
        long size = pageParam.getSize();
        if (size > (long)this.pageSizeLimit) {
            bindingResult.addError(new ObjectError("size", "\u5206\u9875\u6761\u6570\u4e0d\u80fd\u5927\u4e8e" + this.pageSizeLimit));
        }
        if (bindingResult.hasErrors() && this.isBindExceptionRequired(binder, parameter)) {
            throw new MethodArgumentNotValidException(parameter, bindingResult);
        }
        if (mavContainer != null) {
            mavContainer.addAttribute(BindingResult.MODEL_KEY_PREFIX + "pageParam", (Object)bindingResult);
        }
    }

    protected void validateIfApplicable(WebDataBinder binder, MethodParameter parameter) {
        Annotation[] annotations;
        for (Annotation ann : annotations = parameter.getParameterAnnotations()) {
            Object[] validationHints = ValidationAnnotationUtils.determineValidationHints((Annotation)ann);
            if (validationHints == null) continue;
            binder.validate(validationHints);
            break;
        }
    }

    protected boolean isBindExceptionRequired(WebDataBinder binder, MethodParameter parameter) {
        int i = parameter.getParameterIndex();
        Class<?>[] paramTypes = parameter.getExecutable().getParameterTypes();
        boolean hasBindingResult = paramTypes.length > i + 1 && Errors.class.isAssignableFrom(paramTypes[i + 1]);
        return !hasBindingResult;
    }
}

