/*
 * Decompiled with CFR 0.152.
 */
package com.relaxed.autoconfigure.web.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.relaxed.common.core.jackson.JavaTimeModule;
import com.relaxed.common.core.jackson.NullSerializerModifier;
import com.relaxed.common.desensitize.json.DesensitizeStrategy;
import com.relaxed.common.desensitize.json.JsonDesensitizeModule;
import com.relaxed.common.desensitize.json.JsonDesensitizeSerializerModifier;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;

@Configuration
@AutoConfigureBefore(value={JacksonAutoConfiguration.class})
public class JacksonConfig {
    @Bean
    @ConditionalOnClass(value={ObjectMapper.class})
    @ConditionalOnMissingBean(value={ObjectMapper.class})
    public ObjectMapper objectMapper(Jackson2ObjectMapperBuilder builder) {
        ObjectMapper objectMapper = builder.createXmlMapper(false).build();
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        objectMapper.setSerializerFactory(objectMapper.getSerializerFactory().withSerializerModifier((BeanSerializerModifier)new NullSerializerModifier()));
        objectMapper.enable(new JsonParser.Feature[]{JsonReadFeature.ALLOW_UNESCAPED_CONTROL_CHARS.mappedFeature()});
        return objectMapper;
    }

    @Bean
    @ConditionalOnMissingBean(value={JavaTimeModule.class})
    public JavaTimeModule customJavaTimeModule() {
        return new JavaTimeModule();
    }

    @Bean
    @ConditionalOnMissingBean(value={JsonDesensitizeModule.class, DesensitizeStrategy.class})
    public JsonDesensitizeModule jsonDesensitizeModule() {
        JsonDesensitizeSerializerModifier desensitizeModifier = new JsonDesensitizeSerializerModifier();
        return new JsonDesensitizeModule(desensitizeModifier);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={DesensitizeStrategy.class})
    public JsonDesensitizeModule jsonDesensitizeModule(DesensitizeStrategy desensitizeStrategy) {
        JsonDesensitizeSerializerModifier desensitizeModifier = new JsonDesensitizeSerializerModifier(desensitizeStrategy);
        return new JsonDesensitizeModule(desensitizeModifier);
    }
}

