/*
 * Decompiled with CFR 0.152.
 */
package com.relaxed.common.cache;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.relaxed.common.redis.RedisHelper;
import com.relaxed.common.redis.config.CacheProperties;
import com.relaxed.common.redis.config.CachePropertiesHolder;
import com.relaxed.common.redis.core.CacheStringAspect;
import com.relaxed.common.redis.distributor.EventDistributor;
import com.relaxed.common.redis.distributor.RedisDistributor;
import com.relaxed.common.redis.distributor.subscribe.SubscribeHolder;
import com.relaxed.common.redis.lock.scheduled.LockRenewalScheduledTask;
import com.relaxed.common.redis.prefix.DefaultRedisPrefixConverter;
import com.relaxed.common.redis.prefix.IRedisPrefixConverter;
import com.relaxed.common.redis.serialize.JacksonSerializerRelaxed;
import com.relaxed.common.redis.serialize.PrefixJdkRedisSerializer;
import com.relaxed.common.redis.serialize.PrefixStringRedisSerializer;
import com.relaxed.common.redis.serialize.RelaxedRedisSerializer;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.DependsOn;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;

@AutoConfiguration
@EnableConfigurationProperties(value={CacheProperties.class})
public class RelaxedRedisAutoConfiguration {
    private final RedisConnectionFactory redisConnectionFactory;

    @Bean
    @ConditionalOnMissingBean
    public CachePropertiesHolder cachePropertiesHolder(CacheProperties cacheProperties) {
        CachePropertiesHolder cachePropertiesHolder = new CachePropertiesHolder();
        cachePropertiesHolder.setCacheProperties(cacheProperties);
        return cachePropertiesHolder;
    }

    @Bean
    @ConditionalOnMissingBean
    public RelaxedRedisSerializer relaxedRedisSerializer(ObjectMapper objectMapper) {
        return new JacksonSerializerRelaxed(objectMapper);
    }

    @Bean
    @ConditionalOnMissingBean
    public CacheStringAspect cacheStringAspect(StringRedisTemplate stringRedisTemplate, RelaxedRedisSerializer relaxedRedisSerializer) {
        return new CacheStringAspect(stringRedisTemplate, relaxedRedisSerializer);
    }

    @Bean
    @DependsOn(value={"cachePropertiesHolder"})
    @ConditionalOnProperty(prefix="relaxed.redis", name={"key-prefix"})
    @ConditionalOnMissingBean(value={IRedisPrefixConverter.class})
    public IRedisPrefixConverter redisPrefixConverter() {
        return new DefaultRedisPrefixConverter(CachePropertiesHolder.keyPrefix());
    }

    @Bean
    @ConditionalOnProperty(prefix="relaxed.redis", name={"lockRenewal"}, havingValue="true")
    @ConditionalOnMissingBean
    public LockRenewalScheduledTask lockRenewalScheduledTask() {
        return new LockRenewalScheduledTask();
    }

    @Bean
    @ConditionalOnBean(value={IRedisPrefixConverter.class})
    @ConditionalOnMissingBean
    public StringRedisTemplate stringRedisTemplate(IRedisPrefixConverter redisPrefixConverter) {
        StringRedisTemplate template = new StringRedisTemplate();
        template.setConnectionFactory(this.redisConnectionFactory);
        template.setKeySerializer((RedisSerializer)new PrefixStringRedisSerializer(redisPrefixConverter));
        return template;
    }

    @Bean
    @ConditionalOnBean(value={IRedisPrefixConverter.class})
    @ConditionalOnMissingBean(name={"redisTemplate"})
    public RedisTemplate<Object, Object> redisTemplate(IRedisPrefixConverter redisPrefixConverter) {
        RedisTemplate template = new RedisTemplate();
        template.setConnectionFactory(this.redisConnectionFactory);
        template.setKeySerializer((RedisSerializer)new PrefixJdkRedisSerializer(redisPrefixConverter));
        return template;
    }

    @Bean
    @ConditionalOnMissingBean(value={RedisHelper.class})
    public RedisHelper redisHelper(StringRedisTemplate template) {
        RedisHelper.setRedisTemplate((RedisTemplate)template);
        return RedisHelper.INSTANCE;
    }

    @Bean
    @ConditionalOnMissingBean
    public EventDistributor eventDistributor(StringRedisTemplate stringRedisTemplate) {
        return new RedisDistributor(stringRedisTemplate);
    }

    @Bean
    public SubscribeHolder subscribeHolder() {
        return new SubscribeHolder();
    }

    public RelaxedRedisAutoConfiguration(RedisConnectionFactory redisConnectionFactory) {
        this.redisConnectionFactory = redisConnectionFactory;
    }
}

