/*
 * Decompiled with CFR 0.152.
 */
package com.relaxed.autoconfigure.mq.utils;

import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.digest.MD5;
import com.relaxed.autoconfigure.mq.core.domain.MQMeta;
import com.relaxed.autoconfigure.mq.core.enums.MQSendTypeEnum;
import java.util.HashMap;
import java.util.Map;
import org.springframework.core.env.Environment;

public class MQHelper {
    private static Environment environment;
    private static Map<String, MQMeta> globalMQMeta;

    public static void setEnvironment(Environment environment) {
        if (MQHelper.environment == null) {
            MQHelper.environment = environment;
        }
    }

    public static Environment getEnvironment() {
        return environment;
    }

    public static Map<String, MQMeta> globalMQMeta() {
        return globalMQMeta;
    }

    public static MQMeta getMQMeta(String exchangeName, String queueName, String routeKey) {
        String mqKey = MD5.create().digestHex16(exchangeName + queueName + routeKey);
        return globalMQMeta.get(mqKey);
    }

    public static MQMeta register(String exchangeName, String queueName, String routeKey) {
        String mqKey = MD5.create().digestHex16(exchangeName + queueName + routeKey);
        if (globalMQMeta.containsKey(mqKey)) {
            return globalMQMeta.get(mqKey);
        }
        String exchangeNamePlain = MQHelper.resolveParams(exchangeName);
        String queueNamePlain = MQHelper.resolveParams(queueName);
        String routeKeyPlain = MQHelper.resolveParams(routeKey);
        MQMeta mqMeta = MQMeta.builder().exchangeMeta(MQMeta.ExchangeMeta.of(MQSendTypeEnum.QUEUE, exchangeNamePlain)).queueMeta(MQMeta.QueueMeta.of(queueNamePlain)).binding(true).routingKey(routeKeyPlain).build();
        globalMQMeta.put(mqKey, mqMeta);
        return mqMeta;
    }

    public static MQMeta register(MQMeta mqMeta) {
        String exchangeNamePlain = mqMeta.getExchangeMeta().getExchangeName();
        String queueNamePlain = mqMeta.getQueueMeta().getQueueName();
        String routeKeyPlain = mqMeta.getRoutingKey();
        String mqKey = MD5.create().digestHex16(exchangeNamePlain + queueNamePlain + routeKeyPlain);
        if (globalMQMeta.containsKey(mqKey)) {
            return globalMQMeta.get(mqKey);
        }
        globalMQMeta.put(mqKey, mqMeta);
        return mqMeta;
    }

    private static String resolveParams(String paramName) {
        String paramNamePlain = StrUtil.startWith((CharSequence)paramName, (CharSequence)"${") && StrUtil.endWith((CharSequence)paramName, (CharSequence)"}") ? environment.resolveRequiredPlaceholders(paramName) : paramName;
        return paramNamePlain;
    }

    static {
        globalMQMeta = new HashMap<String, MQMeta>();
    }
}

