/*
 * Decompiled with CFR 0.152.
 */
package com.relaxed.autoconfigure.mq.rocketmq;

import java.util.UUID;
import org.apache.rocketmq.common.admin.TopicStatsTable;
import org.apache.rocketmq.tools.admin.DefaultMQAdminExt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocketMQTopicUtil {
    private static final Logger log = LoggerFactory.getLogger(RocketMQTopicUtil.class);
    protected static int topicCreateTime = 30000;

    public static boolean createTopic(String nameSrvAddr, String clusterName, String topic, int queueNum) {
        int defaultWaitTime = 5;
        return RocketMQTopicUtil.createTopic(nameSrvAddr, clusterName, topic, queueNum, defaultWaitTime);
    }

    private static boolean checkTopicExist(DefaultMQAdminExt mqAdminExt, String topic) {
        boolean createResult = false;
        try {
            TopicStatsTable topicInfo = mqAdminExt.examineTopicStats(topic);
            createResult = !topicInfo.getOffsetTable().isEmpty();
        }
        catch (Exception e) {
            log.error("Check topic exist failed", (Throwable)e);
        }
        return createResult;
    }

    public static boolean createTopic(String nameSrvAddr, String clusterName, String topic, int queueNum, int waitTimeSec) {
        boolean createResult = false;
        DefaultMQAdminExt mqAdminExt = new DefaultMQAdminExt();
        mqAdminExt.setInstanceName(UUID.randomUUID().toString());
        mqAdminExt.setNamesrvAddr(nameSrvAddr);
        try {
            mqAdminExt.start();
            mqAdminExt.createTopic(clusterName, topic, queueNum);
        }
        catch (Exception e) {
            log.error("Create topic failed", (Throwable)e);
        }
        long startTime = System.currentTimeMillis();
        while (!createResult) {
            createResult = RocketMQTopicUtil.checkTopicExist(mqAdminExt, topic);
            if (System.currentTimeMillis() - startTime < (long)(waitTimeSec * 1000)) {
                RocketMQTopicUtil.salfSleep(100L);
                continue;
            }
            log.error(String.format("timeout,but create topic[%s] failed!", topic));
            break;
        }
        mqAdminExt.shutdown();
        return createResult;
    }

    private static void salfSleep(Long time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException e) {
            log.error("Sleep interrupted", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    public static boolean initTopic(String topic, String nsAddr, String clusterName) {
        return RocketMQTopicUtil.initTopic(topic, nsAddr, clusterName, 8);
    }

    public static boolean initTopic(String topic, String nsAddr, String clusterName, int queueNumbers) {
        boolean createResult;
        long startTime = System.currentTimeMillis();
        while (!(createResult = RocketMQTopicUtil.createTopic(nsAddr, clusterName, topic, queueNumbers))) {
            if (System.currentTimeMillis() - startTime > (long)topicCreateTime) {
                log.error("topic[{}] is created failed after:{} ms", (Object)topic, (Object)(System.currentTimeMillis() - startTime));
                break;
            }
            RocketMQTopicUtil.salfSleep(500L);
        }
        return createResult;
    }
}

