/*
 * Decompiled with CFR 0.152.
 */
package com.relaxed.autoconfigure.mq.rocketmq;

import com.relaxed.autoconfigure.mq.core.creator.MQDeclareCreator;
import com.relaxed.autoconfigure.mq.core.domain.AbstractMQ;
import com.relaxed.autoconfigure.mq.core.domain.MQMeta;
import com.relaxed.autoconfigure.mq.rocketmq.RocketMQTopicUtil;
import org.apache.rocketmq.common.BrokerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.core.env.Environment;

public class RocketMQDeclareCreator
implements MQDeclareCreator {
    private static final Logger log = LoggerFactory.getLogger(RocketMQDeclareCreator.class);
    private BrokerConfig brokerConfig;

    @Override
    public void declareQueueExchange(AbstractMQ amq, BeanDefinitionRegistry beanDefinitionRegistry, Environment environment, BeanNameGenerator nameGenerator) {
        this.initBrokerConfig(environment);
        MQMeta mqMeta = amq.getMQMeta();
        MQMeta.ExchangeMeta exchangeMeta = mqMeta.getExchangeMeta();
        String exchangeName = exchangeMeta.getExchangeName();
        RocketMQTopicUtil.initTopic(exchangeName, this.brokerConfig.getNamesrvAddr(), this.brokerConfig.getBrokerName());
    }

    void initBrokerConfig(Environment environment) {
        if (this.brokerConfig != null) {
            return;
        }
        String nameServer = (String)environment.getProperty("rocketmq.name-server", String.class);
        log.debug("rocketmq.nameServer = {}", (Object)nameServer);
        if (nameServer == null) {
            log.warn("The necessary spring property 'rocketmq.name-server' is not defined, all rockertmq beans creation are skipped!");
        }
        BrokerConfig brokerConfig = new BrokerConfig();
        brokerConfig.setNamesrvAddr(nameServer);
        brokerConfig.setBrokerIP1("127.0.0.1");
        this.brokerConfig = brokerConfig;
    }
}

