/*
 * Decompiled with CFR 0.152.
 */
package com.relaxed.autoconfigure.mq.rabbitmq;

import com.relaxed.autoconfigure.mq.core.IMQSender;
import com.relaxed.autoconfigure.mq.core.domain.AbstractMQ;
import com.relaxed.autoconfigure.mq.core.domain.MQMeta;
import com.relaxed.autoconfigure.mq.core.enums.MQSendTypeEnum;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.stereotype.Component;

@Component
public class RabbitMQSender
implements IMQSender {
    private final RabbitTemplate rabbitTemplate;

    @Override
    public <C> C client() {
        return (C)this.rabbitTemplate;
    }

    @Override
    public void send(AbstractMQ mqModel) {
        this.send(mqModel, 0);
    }

    @Override
    public void send(AbstractMQ mqModel, int delay) {
        MQMeta mqMeta = mqModel.getMQMeta();
        MQMeta.ExchangeMeta exchangeMeta = mqMeta.getExchangeMeta();
        MQMeta.QueueMeta queueMeta = mqMeta.getQueueMeta();
        MQSendTypeEnum exchangeType = exchangeMeta.getExchangeType();
        switch (exchangeType) {
            case QUEUE: {
                this.rabbitTemplate.convertAndSend(exchangeMeta.getExchangeName(), mqMeta.getRoutingKey(), (Object)mqModel.toMessage());
                break;
            }
            case BROADCAST: {
                this.rabbitTemplate.convertAndSend(exchangeMeta.getExchangeName(), null, (Object)mqModel.toMessage());
                break;
            }
            case DELAY: {
                this.rabbitTemplate.convertAndSend(queueMeta.getQueueName(), (Object)mqModel.toMessage(), messagePostProcessor -> {
                    messagePostProcessor.getMessageProperties().setExpiration(String.valueOf(Math.toIntExact(delay * 1000)));
                    return messagePostProcessor;
                });
            }
        }
    }

    public RabbitMQSender(RabbitTemplate rabbitTemplate) {
        this.rabbitTemplate = rabbitTemplate;
    }
}

