/*
 * Decompiled with CFR 0.152.
 */
package com.relaxed.autoconfigure.mq.rabbitmq;

import com.relaxed.autoconfigure.mq.core.creator.AbstractMQDeclareCreator;
import com.relaxed.autoconfigure.mq.core.domain.MQMeta;
import com.relaxed.autoconfigure.mq.core.enums.MQSendTypeEnum;
import java.util.Collections;
import java.util.Map;
import java.util.function.Supplier;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.CustomExchange;
import org.springframework.amqp.core.FanoutExchange;
import org.springframework.amqp.core.Queue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;

public class RabbitMQDeclareCreator
extends AbstractMQDeclareCreator {
    @Override
    protected BeanDefinitionBuilder generateQueueBeanDefBuilder(MQMeta.QueueMeta queueMeta) {
        Supplier<Queue> queueSupplier = () -> new Queue(queueMeta.getQueueName(), true, false, false, queueMeta.getArgs());
        BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(Queue.class, queueSupplier);
        return beanDefinitionBuilder;
    }

    @Override
    protected void registeredBinding(BeanDefinitionRegistry beanDefinitionRegistry, BeanNameGenerator nameGenerator, String queueName, String exchangeName, String routingKey) {
        Supplier<Binding> bindingSupplier = () -> new Binding(queueName, Binding.DestinationType.QUEUE, exchangeName, routingKey, Collections.emptyMap());
        BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(Binding.class, bindingSupplier);
        AbstractBeanDefinition bindBeanDefinition = beanDefinitionBuilder.getBeanDefinition();
        beanDefinitionRegistry.registerBeanDefinition(nameGenerator.generateBeanName((BeanDefinition)bindBeanDefinition, beanDefinitionRegistry), (BeanDefinition)bindBeanDefinition);
    }

    @Override
    protected BeanDefinitionBuilder generateExchangeBeanDefBuilder(MQMeta.ExchangeMeta exchangeMeta, String exchangeName) {
        BeanDefinitionBuilder beanDefinitionBuilder;
        MQSendTypeEnum exchangeType = exchangeMeta.getExchangeType();
        Map<String, Object> args = exchangeMeta.getArgs();
        if (exchangeType == MQSendTypeEnum.BROADCAST) {
            Supplier<FanoutExchange> fanoutExchangeSupplier = () -> new FanoutExchange(exchangeName, true, false, args);
            beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(FanoutExchange.class, fanoutExchangeSupplier);
        } else {
            Supplier<CustomExchange> customExchangeSupplier = () -> new CustomExchange(exchangeName, "direct", true, false, args);
            beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(CustomExchange.class, customExchangeSupplier);
        }
        return beanDefinitionBuilder;
    }
}

