/*
 * Decompiled with CFR 0.152.
 */
package com.relaxed.autoconfigure.mq.core.annotation;

import com.relaxed.autoconfigure.mq.core.annotation.EnableMQ;
import com.relaxed.autoconfigure.mq.core.annotation.MQScanConfigurer;
import com.relaxed.autoconfigure.mq.core.creator.MQDeclareCreator;
import com.relaxed.autoconfigure.mq.core.creator.NullMQDeclareCreator;
import com.relaxed.autoconfigure.mq.core.enums.MQTypeEnum;
import com.relaxed.autoconfigure.mq.core.exception.MQException;
import com.relaxed.autoconfigure.mq.rabbitmq.RabbitMQDeclareCreator;
import com.relaxed.autoconfigure.mq.rocketmq.RocketMQDeclareCreator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class MQScannerRegister
implements EnvironmentAware,
ImportBeanDefinitionRegistrar {
    private Environment environment;

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        AnnotationAttributes mapperScanAttrs = AnnotationAttributes.fromMap((Map)importingClassMetadata.getAnnotationAttributes(EnableMQ.class.getName()));
        if (mapperScanAttrs != null) {
            this.registerBeanDefinitions(importingClassMetadata, mapperScanAttrs, registry, MQScannerRegister.generateBaseBeanName(importingClassMetadata, 0));
        }
    }

    void registerBeanDefinitions(AnnotationMetadata annoMeta, AnnotationAttributes annoAttrs, BeanDefinitionRegistry registry, String beanName) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(MQScanConfigurer.class);
        MQTypeEnum mqType = (MQTypeEnum)annoAttrs.getEnum("mqType");
        Class<? extends MQDeclareCreator> mqCreatorClass = this.chooseCreator(mqType, annoAttrs.getClass("creator"));
        MQDeclareCreator mqDeclareCreator = (MQDeclareCreator)BeanUtils.instantiateClass(mqCreatorClass);
        builder.addPropertyValue("creator", (Object)mqDeclareCreator);
        Class nameGenerator = annoAttrs.getClass("nameGenerator");
        BeanNameGenerator beanNameGenerator = (BeanNameGenerator)BeanUtils.instantiateClass((Class)nameGenerator);
        builder.addPropertyValue("nameGenerator", (Object)beanNameGenerator);
        builder.addPropertyValue("environment", (Object)this.environment);
        ArrayList<String> basePackages = new ArrayList<String>();
        basePackages.addAll(Arrays.stream(annoAttrs.getStringArray("basePackages")).filter(StringUtils::hasText).collect(Collectors.toList()));
        if (basePackages.isEmpty()) {
            basePackages.add(MQScannerRegister.getDefaultBasePackage(annoMeta));
        }
        builder.addPropertyValue("basePackage", (Object)StringUtils.collectionToCommaDelimitedString(basePackages));
        registry.registerBeanDefinition(beanName, (BeanDefinition)builder.getBeanDefinition());
    }

    private Class<? extends MQDeclareCreator> chooseCreator(MQTypeEnum mqType, Class<? extends MQDeclareCreator> mqCreatorClass) {
        switch (mqType) {
            case RABBIT_MQ: {
                mqCreatorClass = NullMQDeclareCreator.class.equals(mqCreatorClass) ? RabbitMQDeclareCreator.class : mqCreatorClass;
                break;
            }
            case ROCKET_MQ: {
                mqCreatorClass = NullMQDeclareCreator.class.equals(mqCreatorClass) ? RocketMQDeclareCreator.class : mqCreatorClass;
                break;
            }
            case OTHER: {
                if (!NullMQDeclareCreator.class.equals(mqCreatorClass)) break;
                throw new MQException("mq declare creator can not null mq declare creator");
            }
        }
        return mqCreatorClass;
    }

    private static String getDefaultBasePackage(AnnotationMetadata importingClassMetadata) {
        return ClassUtils.getPackageName((String)importingClassMetadata.getClassName());
    }

    private static String generateBaseBeanName(AnnotationMetadata importingClassMetadata, int index) {
        return importingClassMetadata.getClassName() + "#" + MQScanConfigurer.class.getSimpleName() + "#" + index;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }
}

