/*
 * Decompiled with CFR 0.152.
 */
package com.relaxed.common.mail;

import com.relaxed.extend.mail.sender.MailSender;
import com.relaxed.extend.mail.sender.MailSenderImpl;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.mail.MailSenderAutoConfiguration;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.mail.javamail.JavaMailSender;

@AutoConfigureAfter(value={MailSenderAutoConfiguration.class})
@Configuration(proxyBeanMethods=false)
public class MailAutoConfiguration {
    @Value(value="${spring.mail.properties.from}")
    private String defaultForm;

    @Bean
    @ConditionalOnBean(value={JavaMailSender.class})
    @ConditionalOnMissingBean(value={MailSender.class})
    public MailSender mailSenderImpl(JavaMailSender javaMailSender, ApplicationEventPublisher applicationEventPublisher) {
        return new MailSenderImpl(javaMailSender, applicationEventPublisher, this.defaultForm);
    }
}

