/*
 * Decompiled with CFR 0.152.
 */
package com.relaxed.autoconfigure.exception;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.relaxed.autoconfigure.exception.ExceptionHandleProperties;
import com.relaxed.common.exception.ExceptionHandleConfig;
import com.relaxed.common.exception.handler.DefaultGlobalExceptionHandler;
import com.relaxed.common.exception.handler.GlobalExceptionHandler;
import com.relaxed.common.exception.holder.ExceptionNotifierHolder;
import com.relaxed.common.exception.notifier.DefaultGlobalExceptionNotifier;
import com.relaxed.common.exception.notifier.DefaultNoticeResultDecision;
import com.relaxed.common.exception.notifier.DingTalkGlobalExceptionNotifier;
import com.relaxed.common.exception.notifier.ExceptionNotifier;
import com.relaxed.common.exception.notifier.MailGlobalExceptionNotifier;
import com.relaxed.common.exception.notifier.NoticeResultDecision;
import com.relaxed.common.exception.notifier.WechatGlobalExceptionNotifier;
import com.relaxed.extend.dingtalk.request.DingTalkSender;
import com.relaxed.extend.mail.sender.MailSender;
import com.relaxed.extend.wechat.request.WechatSender;
import java.util.ArrayList;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@EnableConfigurationProperties(value={ExceptionHandleProperties.class})
@Configuration(proxyBeanMethods=false)
public class ExceptionAutoConfiguration {
    private static final String DING_TALK = "DING_TALK";
    private static final String MAIL = "MAIL";
    private static final String WECHAT = "WECHAT";
    @Value(value="${spring.application.name: unknown-application}")
    private String applicationName;

    @Bean
    @ConditionalOnMissingBean
    public NoticeResultDecision noticeResultDecision() {
        return new DefaultNoticeResultDecision();
    }

    @Bean
    @ConditionalOnMissingBean
    public ExceptionNotifierHolder exceptionNotifierHolder(ObjectProvider<ExceptionNotifier> exceptionNotifiers, NoticeResultDecision noticeResultDecision) {
        ArrayList<DefaultGlobalExceptionNotifier> notifiers = new ArrayList<DefaultGlobalExceptionNotifier>();
        exceptionNotifiers.orderedStream().iterator().forEachRemaining(notifiers::add);
        if (CollectionUtil.isEmpty(notifiers)) {
            notifiers.add(new DefaultGlobalExceptionNotifier());
        }
        return new ExceptionNotifierHolder(notifiers, noticeResultDecision);
    }

    @Bean
    @ConditionalOnMissingBean
    public GlobalExceptionHandler defaultGlobalExceptionHandler(ExceptionHandleProperties exceptionHandleProperties, ExceptionNotifierHolder exceptionNotifierHolder) {
        ExceptionHandleConfig exceptionHandleConfig = (ExceptionHandleConfig)BeanUtil.toBean((Object)exceptionHandleProperties, ExceptionHandleConfig.class);
        return new DefaultGlobalExceptionHandler(exceptionHandleConfig, exceptionNotifierHolder, this.applicationName);
    }

    @Bean
    @ConditionalOnProperty(prefix="relaxed.exception.channels", name={"WECHAT"}, havingValue="true")
    public ExceptionNotifier wechatGlobalExceptionNotifier(ApplicationContext context) {
        return new WechatGlobalExceptionNotifier(WECHAT, this.applicationName, (WechatSender)context.getBean(WechatSender.class));
    }

    @Bean
    @ConditionalOnProperty(prefix="relaxed.exception.channels", name={"DING_TALK"}, havingValue="true")
    public ExceptionNotifier dingTalkGlobalExceptionNotifier(ApplicationContext context) {
        return new DingTalkGlobalExceptionNotifier(DING_TALK, this.applicationName, (DingTalkSender)context.getBean(DingTalkSender.class));
    }

    @Bean
    @ConditionalOnProperty(prefix="relaxed.exception.channels", name={"MAIL"}, havingValue="true")
    public ExceptionNotifier mailGlobalExceptionNotifier(ExceptionHandleProperties exceptionHandleProperties, ApplicationContext context) {
        return new MailGlobalExceptionNotifier(MAIL, this.applicationName, (MailSender)context.getBean(MailSender.class), exceptionHandleProperties.getReceiveEmails());
    }
}

