/*
 * Decompiled with CFR 0.152.
 */
package com.relaxed.starter.download.handler;

import cn.hutool.extra.servlet.ServletUtil;
import com.relaxed.starter.download.annotation.ResponseDownload;
import com.relaxed.starter.download.domain.DownloadModel;
import com.relaxed.starter.download.enums.DownTypeEnum;
import com.relaxed.starter.download.handler.AbstractDownloadHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalDownloadHandler
extends AbstractDownloadHandler {
    private static final Logger log = LoggerFactory.getLogger(LocalDownloadHandler.class);

    @Override
    public boolean support(DownloadModel downloadModel, ResponseDownload responseDownload) {
        return DownTypeEnum.LOCAL.equals((Object)responseDownload.channel());
    }

    @Override
    protected void write(DownloadModel downloadModel, HttpServletResponse response, ResponseDownload responseDownload) {
        String parentPath = downloadModel.getParentPath();
        String fileName = downloadModel.getFileName();
        File file = new File(parentPath, fileName);
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            ServletUtil.write((HttpServletResponse)response, (InputStream)fileInputStream);
        }
        catch (Exception e) {
            log.error("\u4e0b\u8f7d\u6587\u4ef6,\u6e20\u9053{} \u8def\u5f84{}\uff0c\u540d\u79f0{}\u5f02\u5e38", new Object[]{responseDownload.channel(), parentPath, fileName, e});
            throw e;
        }
    }
}

