/*
 * Decompiled with CFR 0.152.
 */
package com.relaxed.starter.download.handler;

import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import com.relaxed.starter.download.annotation.ResponseDownload;
import com.relaxed.starter.download.domain.DownloadModel;
import com.relaxed.starter.download.enums.DownTypeEnum;
import com.relaxed.starter.download.exception.DownloadException;
import com.relaxed.starter.download.functions.DownloadCallback;
import com.relaxed.starter.download.handler.DownloadHandler;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Optional;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class DownloadHandlerChain
implements ApplicationContextAware {
    private final List<DownloadHandler> downloadHandlerList;
    protected ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void check(Object o, ResponseDownload responseDownload) {
        if (!(o instanceof DownloadModel)) {
            throw new DownloadException("return value  type must be  DownloadModel");
        }
        DownloadModel downloadModel = (DownloadModel)o;
        if (StrUtil.isEmpty((CharSequence)downloadModel.getFileType())) {
            throw new DownloadException("@ResponseDownload fileType \u914d\u7f6e\u4e0d\u5b58\u5728");
        }
        if (StrUtil.isEmpty((CharSequence)downloadModel.getFileName())) {
            throw new DownloadException("filename can not be null");
        }
        Object[] headers = responseDownload.headers();
        if (ArrayUtil.isNotEmpty((Object[])headers) && headers.length % 2 != 0) {
            throw new DownloadException("@ResponseDownload headers \u5fc5\u987b\u4e3a2\u7684\u500d\u6570");
        }
        if (DownTypeEnum.OTHER.equals((Object)responseDownload.channel()) && this.isInterface(responseDownload.customHandler())) {
            throw new DownloadException("@ResponseDownload customHandler \u5fc5\u987b\u4e3a\u81ea\u5b9a\u4e49\u5b9e\u5217bean");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Object returnValue, HttpServletResponse response, ResponseDownload responseDownload) {
        this.check(returnValue, responseDownload);
        DownloadModel downloadModel = (DownloadModel)returnValue;
        if (DownTypeEnum.OTHER.equals((Object)responseDownload.channel())) {
            ((DownloadHandler)this.applicationContext.getBean(responseDownload.customHandler())).download(downloadModel, response, responseDownload);
            return;
        }
        try {
            this.downloadHandlerList.stream().filter(handler -> handler.support(downloadModel, responseDownload)).findFirst().ifPresent(handler -> handler.download(downloadModel, response, responseDownload));
        }
        finally {
            Optional.ofNullable(downloadModel.getDownloadCallback()).ifPresent(DownloadCallback::postProcess);
        }
    }

    private boolean isInterface(Class<? extends DownloadHandler> downloadHandlerClass) {
        return Modifier.isInterface(downloadHandlerClass.getModifiers());
    }

    public DownloadHandlerChain(List<DownloadHandler> downloadHandlerList) {
        this.downloadHandlerList = downloadHandlerList;
    }
}

