/*
 * Decompiled with CFR 0.152.
 */
package com.relaxed.starter.download.handler;

import cn.hutool.core.util.StrUtil;
import com.relaxed.starter.download.annotation.ResponseDownload;
import com.relaxed.starter.download.domain.DownloadModel;
import com.relaxed.starter.download.handler.DownloadHandler;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.http.MediaTypeFactory;
import org.springframework.util.MimeType;

public abstract class AbstractDownloadHandler
implements DownloadHandler,
ApplicationContextAware {
    protected ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    public void download(DownloadModel downloadModel, HttpServletResponse response, ResponseDownload responseDownload) {
        String fileName = this.extractFileName(responseDownload, downloadModel);
        String contentType = MediaTypeFactory.getMediaType((String)fileName).map(MimeType::toString).orElse(responseDownload.contentType());
        response.setContentType(contentType);
        response.setCharacterEncoding(responseDownload.charset());
        this.buildHeaders(response, responseDownload, fileName);
        this.write(downloadModel, response, responseDownload);
    }

    protected abstract void write(DownloadModel var1, HttpServletResponse var2, ResponseDownload var3);

    protected void buildHeaders(HttpServletResponse response, ResponseDownload responseDownload, String fileName) {
        boolean inline = responseDownload.inline();
        String contentDisplay = inline ? "inline" : "attachment";
        response.setHeader("Content-Disposition", contentDisplay + ";filename=" + fileName);
        String[] headers = responseDownload.headers();
        if (headers.length % 2 == 0) {
            for (int i = 0; i < headers.length; i += 2) {
                response.setHeader(headers[i], headers[i + 1]);
            }
        }
    }

    protected String extractFileName(ResponseDownload responseDownload, DownloadModel downloadModel) {
        String displayFileName = StrUtil.isBlank((CharSequence)downloadModel.getDisplayFileName()) ? downloadModel.getFileName() : downloadModel.getDisplayFileName();
        return URLEncoder.encode(displayFileName, "UTF-8");
    }
}

