/*
 * Decompiled with CFR 0.152.
 */
package com.relaxed.starter.download.domain;

import cn.hutool.core.util.StrUtil;
import com.relaxed.starter.download.functions.DownloadCallback;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.springframework.util.Assert;

public class DownloadModel {
    private String fileName;
    private String displayFileName;
    private String fileType;
    private String parentPath;
    private String fullFilePath;
    private String separator = File.separator;
    private Map<String, Object> extra = new HashMap<String, Object>();
    private DownloadCallback downloadCallback;

    public DownloadModel() {
    }

    public DownloadModel(String parentPath, String fileName, String fileType) {
        this(parentPath, fileName, fileType, File.separator);
    }

    public DownloadModel(String parentPath, String fileName, String fileType, String separator) {
        Assert.hasText((String)fileName, (String)"filename must be exists");
        this.fileName = fileName;
        this.fileType = fileType;
        this.parentPath = parentPath;
        this.separator = separator;
        this.fullFilePath = parentPath + this.separator + fileName;
    }

    public DownloadModel(String fullFilePath) {
        this(fullFilePath, File.separator);
    }

    public DownloadModel(String fullFilePath, String separator) {
        Assert.hasText((String)fullFilePath, (String)"fullFilePath must be exists");
        this.separator = separator;
        int lastSeparator = fullFilePath.lastIndexOf(separator);
        this.fileName = StrUtil.sub((CharSequence)fullFilePath, (int)(lastSeparator + 1), (int)fullFilePath.length());
        this.parentPath = StrUtil.sub((CharSequence)fullFilePath, (int)0, (int)lastSeparator);
        this.fullFilePath = fullFilePath;
        this.fileType = StrUtil.sub((CharSequence)this.fileName, (int)(this.fileName.lastIndexOf(".") + 1), (int)this.fileName.length());
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getDisplayFileName() {
        return this.displayFileName;
    }

    public String getFileType() {
        return this.fileType;
    }

    public String getParentPath() {
        return this.parentPath;
    }

    public String getFullFilePath() {
        return this.fullFilePath;
    }

    public String getSeparator() {
        return this.separator;
    }

    public Map<String, Object> getExtra() {
        return this.extra;
    }

    public DownloadCallback getDownloadCallback() {
        return this.downloadCallback;
    }

    public DownloadModel setFileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    public DownloadModel setDisplayFileName(String displayFileName) {
        this.displayFileName = displayFileName;
        return this;
    }

    public DownloadModel setFileType(String fileType) {
        this.fileType = fileType;
        return this;
    }

    public DownloadModel setParentPath(String parentPath) {
        this.parentPath = parentPath;
        return this;
    }

    public DownloadModel setFullFilePath(String fullFilePath) {
        this.fullFilePath = fullFilePath;
        return this;
    }

    public DownloadModel setSeparator(String separator) {
        this.separator = separator;
        return this;
    }

    public DownloadModel setExtra(Map<String, Object> extra) {
        this.extra = extra;
        return this;
    }

    public DownloadModel setDownloadCallback(DownloadCallback downloadCallback) {
        this.downloadCallback = downloadCallback;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DownloadModel)) {
            return false;
        }
        DownloadModel other = (DownloadModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$fileName = this.getFileName();
        String other$fileName = other.getFileName();
        if (this$fileName == null ? other$fileName != null : !this$fileName.equals(other$fileName)) {
            return false;
        }
        String this$displayFileName = this.getDisplayFileName();
        String other$displayFileName = other.getDisplayFileName();
        if (this$displayFileName == null ? other$displayFileName != null : !this$displayFileName.equals(other$displayFileName)) {
            return false;
        }
        String this$fileType = this.getFileType();
        String other$fileType = other.getFileType();
        if (this$fileType == null ? other$fileType != null : !this$fileType.equals(other$fileType)) {
            return false;
        }
        String this$parentPath = this.getParentPath();
        String other$parentPath = other.getParentPath();
        if (this$parentPath == null ? other$parentPath != null : !this$parentPath.equals(other$parentPath)) {
            return false;
        }
        String this$fullFilePath = this.getFullFilePath();
        String other$fullFilePath = other.getFullFilePath();
        if (this$fullFilePath == null ? other$fullFilePath != null : !this$fullFilePath.equals(other$fullFilePath)) {
            return false;
        }
        String this$separator = this.getSeparator();
        String other$separator = other.getSeparator();
        if (this$separator == null ? other$separator != null : !this$separator.equals(other$separator)) {
            return false;
        }
        Map<String, Object> this$extra = this.getExtra();
        Map<String, Object> other$extra = other.getExtra();
        if (this$extra == null ? other$extra != null : !((Object)this$extra).equals(other$extra)) {
            return false;
        }
        DownloadCallback this$downloadCallback = this.getDownloadCallback();
        DownloadCallback other$downloadCallback = other.getDownloadCallback();
        return !(this$downloadCallback == null ? other$downloadCallback != null : !this$downloadCallback.equals(other$downloadCallback));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DownloadModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $fileName = this.getFileName();
        result = result * 59 + ($fileName == null ? 43 : $fileName.hashCode());
        String $displayFileName = this.getDisplayFileName();
        result = result * 59 + ($displayFileName == null ? 43 : $displayFileName.hashCode());
        String $fileType = this.getFileType();
        result = result * 59 + ($fileType == null ? 43 : $fileType.hashCode());
        String $parentPath = this.getParentPath();
        result = result * 59 + ($parentPath == null ? 43 : $parentPath.hashCode());
        String $fullFilePath = this.getFullFilePath();
        result = result * 59 + ($fullFilePath == null ? 43 : $fullFilePath.hashCode());
        String $separator = this.getSeparator();
        result = result * 59 + ($separator == null ? 43 : $separator.hashCode());
        Map<String, Object> $extra = this.getExtra();
        result = result * 59 + ($extra == null ? 43 : ((Object)$extra).hashCode());
        DownloadCallback $downloadCallback = this.getDownloadCallback();
        result = result * 59 + ($downloadCallback == null ? 43 : $downloadCallback.hashCode());
        return result;
    }

    public String toString() {
        return "DownloadModel(fileName=" + this.getFileName() + ", displayFileName=" + this.getDisplayFileName() + ", fileType=" + this.getFileType() + ", parentPath=" + this.getParentPath() + ", fullFilePath=" + this.getFullFilePath() + ", separator=" + this.getSeparator() + ", extra=" + this.getExtra() + ", downloadCallback=" + this.getDownloadCallback() + ")";
    }
}

