/*
 * Decompiled with CFR 0.152.
 */
package com.relaxed.starter.download.aop;

import com.relaxed.starter.download.annotation.ResponseDownload;
import com.relaxed.starter.download.handler.DownloadHandlerChain;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.util.Assert;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.method.support.ModelAndViewContainer;

public class ResponseDownloadReturnValueHandler
implements HandlerMethodReturnValueHandler {
    private static final Logger log = LoggerFactory.getLogger(ResponseDownloadReturnValueHandler.class);
    private final DownloadHandlerChain downloadHandlerChain;

    public boolean supportsReturnType(MethodParameter parameter) {
        return parameter.getMethodAnnotation(ResponseDownload.class) != null;
    }

    public void handleReturnValue(Object returnValue, MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest nativeWebRequest) throws Exception {
        HttpServletResponse response = (HttpServletResponse)nativeWebRequest.getNativeResponse(HttpServletResponse.class);
        Assert.state((response != null ? 1 : 0) != 0, (String)"No HttpServletResponse");
        ResponseDownload responseDownload = (ResponseDownload)parameter.getMethodAnnotation(ResponseDownload.class);
        Assert.state((responseDownload != null ? 1 : 0) != 0, (String)"No @ResponseDownload");
        mavContainer.setRequestHandled(true);
        this.downloadHandlerChain.process(returnValue, response, responseDownload);
    }

    public ResponseDownloadReturnValueHandler(DownloadHandlerChain downloadHandlerChain) {
        this.downloadHandlerChain = downloadHandlerChain;
    }
}

