/*
 * Decompiled with CFR 0.152.
 */
package com.relaxed.starter.download;

import com.relaxed.common.jsch.sftp.client.ISftpClient;
import com.relaxed.common.oss.s3.OssClient;
import com.relaxed.starter.download.aop.ResponseDownloadReturnValueHandler;
import com.relaxed.starter.download.handler.DownloadHandler;
import com.relaxed.starter.download.handler.DownloadHandlerChain;
import com.relaxed.starter.download.handler.LocalDownloadHandler;
import com.relaxed.starter.download.handler.OssDownloadHandler;
import com.relaxed.starter.download.handler.SftpDownloadHandler;
import java.util.List;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ResponseDownloadHandler {
    @Bean
    @ConditionalOnMissingBean(value={LocalDownloadHandler.class})
    public LocalDownloadHandler localDownloadHandler() {
        return new LocalDownloadHandler();
    }

    @Bean
    public DownloadHandlerChain downloadHandlerChain(List<DownloadHandler> downloadHandlerList) {
        return new DownloadHandlerChain(downloadHandlerList);
    }

    @Bean
    @ConditionalOnMissingBean
    public ResponseDownloadReturnValueHandler responseDownloadReturnValueHandler(DownloadHandlerChain downloadHandlerChain) {
        return new ResponseDownloadReturnValueHandler(downloadHandlerChain);
    }

    @Configuration
    @ConditionalOnClass(value={OssClient.class})
    public static class OssRegister {
        @Bean
        @ConditionalOnMissingBean(value={OssDownloadHandler.class})
        public OssDownloadHandler ossDownloadHandler(OssClient ossClient) {
            return new OssDownloadHandler(ossClient);
        }
    }

    @Configuration
    @ConditionalOnClass(value={ISftpClient.class})
    public static class ISftpRegister {
        @Bean
        @ConditionalOnMissingBean(value={SftpDownloadHandler.class})
        public SftpDownloadHandler sftpDownloadHandler(ISftpClient iSftpClient) {
            return new SftpDownloadHandler(iSftpClient);
        }
    }
}

