/*
 * Decompiled with CFR 0.152.
 */
package com.relaxed.common.dingtalk;

import com.relaxed.common.dingtalk.DingTalkProperties;
import com.relaxed.extend.dingtalk.request.DingTalkSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(name={"relaxed.dingtalk.url"})
@EnableConfigurationProperties(value={DingTalkProperties.class})
public class DingTalkAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(DingTalkAutoConfiguration.class);
    private final DingTalkProperties dingTalkProperties;

    @Bean
    @ConditionalOnMissingBean
    public DingTalkSender dingTalkSender() {
        return new DingTalkSender(this.dingTalkProperties.getUrl()).setSecret(this.dingTalkProperties.getSecret());
    }

    public DingTalkAutoConfiguration(DingTalkProperties dingTalkProperties) {
        this.dingTalkProperties = dingTalkProperties;
    }
}

