/*
 * Decompiled with CFR 0.152.
 */
package com.relaxed.oauth2.common.util;

import cn.hutool.core.codec.Base64;
import cn.hutool.crypto.Mode;
import cn.hutool.crypto.Padding;
import cn.hutool.crypto.symmetric.AES;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.DelegatingPasswordEncoder;
import org.springframework.security.crypto.password.LdapShaPasswordEncoder;
import org.springframework.security.crypto.password.Md4PasswordEncoder;
import org.springframework.security.crypto.password.MessageDigestPasswordEncoder;
import org.springframework.security.crypto.password.NoOpPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.crypto.password.Pbkdf2PasswordEncoder;
import org.springframework.security.crypto.password.StandardPasswordEncoder;
import org.springframework.security.crypto.scrypt.SCryptPasswordEncoder;

public final class PasswordUtils {
    public static final PasswordEncoder ENCODER = PasswordUtils.createDelegatingPasswordEncoder();

    private PasswordUtils() {
    }

    private static PasswordEncoder createDelegatingPasswordEncoder() {
        String encodingId = "bcrypt";
        HashMap<String, Object> encoders = new HashMap<String, Object>(10);
        BCryptPasswordEncoder bCryptPasswordEncoder = new BCryptPasswordEncoder();
        encoders.put(encodingId, bCryptPasswordEncoder);
        encoders.put("ldap", new LdapShaPasswordEncoder());
        encoders.put("MD4", new Md4PasswordEncoder());
        encoders.put("MD5", new MessageDigestPasswordEncoder("MD5"));
        encoders.put("noop", NoOpPasswordEncoder.getInstance());
        encoders.put("pbkdf2", new Pbkdf2PasswordEncoder());
        encoders.put("scrypt", new SCryptPasswordEncoder());
        encoders.put("SHA-1", new MessageDigestPasswordEncoder("SHA-1"));
        encoders.put("SHA-256", new MessageDigestPasswordEncoder("SHA-256"));
        encoders.put("sha256", new StandardPasswordEncoder());
        DelegatingPasswordEncoder delegatingPasswordEncoder = new DelegatingPasswordEncoder(encodingId, encoders);
        delegatingPasswordEncoder.setDefaultPasswordEncoderForMatches((PasswordEncoder)bCryptPasswordEncoder);
        return delegatingPasswordEncoder;
    }

    public static String decodeAES(String aesPass, String secretKey) {
        byte[] secretKeyBytes = secretKey.getBytes();
        AES aes = new AES(Mode.CBC, Padding.PKCS5Padding, secretKeyBytes, secretKeyBytes);
        byte[] result = aes.decrypt(Base64.decode((byte[])aesPass.getBytes(StandardCharsets.UTF_8)));
        return new String(result, StandardCharsets.UTF_8);
    }

    public static String encodeAESBase64(String password, String secretKey) {
        byte[] secretKeyBytes = secretKey.getBytes();
        AES aes = new AES(Mode.CBC, Padding.PKCS5Padding, secretKeyBytes, secretKeyBytes);
        return aes.encryptBase64(password, StandardCharsets.UTF_8);
    }

    public static String encode(CharSequence rawPassword) {
        return ENCODER.encode(rawPassword);
    }

    public static boolean matches(CharSequence rawPassword, String encodedPassword) {
        return ENCODER.matches(rawPassword, encodedPassword);
    }

    public static boolean upgradeEncoding(String encodedPassword) {
        return ENCODER.upgradeEncoding(encodedPassword);
    }
}

