/*
 * Decompiled with CFR 0.152.
 */
package com.relaxed.extend.mybatis.encrypt;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import com.relaxed.extend.mybatis.encrypt.FieldEncryptor;
import com.relaxed.extend.mybatis.encrypt.FieldSecurityHolder;
import com.relaxed.extend.mybatis.encrypt.FieldSecurityProperties;
import com.relaxed.extend.mybatis.encrypt.sec.AesFieldEncryptor;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.lang.Nullable;

@EnableConfigurationProperties(value={FieldSecurityProperties.class})
@Configuration(proxyBeanMethods=false)
public class MybatisEncryptConfiguration {
    private final FieldSecurityProperties fieldSecurityProperties;

    @Bean
    public FieldSecurityHolder securityHolder(@Nullable ObjectProvider<List<FieldEncryptor>> fieldSecProvider) {
        List fieldEncryptorList = (List)fieldSecProvider.getIfAvailable();
        String defSec = this.fieldSecurityProperties.getDefSec();
        Assert.notBlank((CharSequence)defSec, (String)"\u9ed8\u8ba4\u52a0\u5bc6\u7b97\u6cd5\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u914d\u7f6e\u5c5e\u6027:{}", (Object[])new Object[]{"relaxed.mybatis.sec"});
        FieldSecurityHolder instance = FieldSecurityHolder.INSTANCE;
        if (CollectionUtil.isNotEmpty((Collection)fieldEncryptorList)) {
            this.initFieldSec(instance);
            for (FieldEncryptor fieldEncryptor : fieldEncryptorList) {
                instance.regByType(fieldEncryptor.secType(), fieldEncryptor);
            }
            FieldEncryptor defFieldEncryptor = instance.getByType(defSec);
            Assert.notNull((Object)defFieldEncryptor, (String)"\u52a0\u5bc6\u7b97\u6cd5:{},\u6267\u884c\u5668\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{defSec});
        } else {
            this.initFieldSec(instance);
            Assert.notNull((Object)instance.getByType(defSec), (String)"\u52a0\u5bc6\u7b97\u6cd5:{},\u6267\u884c\u5668\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{defSec});
        }
        return instance;
    }

    private void initFieldSec(FieldSecurityHolder instance) {
        AesFieldEncryptor aesFieldEncryptor = new AesFieldEncryptor(this.fieldSecurityProperties.getAes());
        instance.regByType("AES", aesFieldEncryptor);
    }

    public MybatisEncryptConfiguration(FieldSecurityProperties fieldSecurityProperties) {
        this.fieldSecurityProperties = fieldSecurityProperties;
    }
}

