/*
 * Decompiled with CFR 0.152.
 */
package com.relaxed.extend.mybatis.encrypt;

import cn.hutool.core.util.ClassUtil;
import com.relaxed.extend.mybatis.encrypt.FieldEncryptHelper;
import java.sql.Statement;
import java.util.Collection;
import org.apache.ibatis.executor.resultset.ResultSetHandler;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Signature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Intercepts(value={@Signature(type=ResultSetHandler.class, method="handleResultSets", args={Statement.class})})
@Component
public class MybatisDecryptInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(MybatisDecryptInterceptor.class);
    private final FieldEncryptHelper fieldEncryptHelper;

    public Object intercept(Invocation invocation) throws Throwable {
        Object result = invocation.proceed();
        if (ClassUtil.isAssignable(Collection.class, result.getClass())) {
            this.fieldEncryptHelper.decrypt((Collection)result);
        } else {
            this.fieldEncryptHelper.decrypt(result);
        }
        return result;
    }

    public MybatisDecryptInterceptor(FieldEncryptHelper fieldEncryptHelper) {
        this.fieldEncryptHelper = fieldEncryptHelper;
    }
}

