/*
 * Decompiled with CFR 0.152.
 */
package com.relaxed.extend.mybatis.encrypt;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.relaxed.extend.mybatis.encrypt.FieldEncrypt;
import com.relaxed.extend.mybatis.encrypt.FieldEncryptor;
import com.relaxed.extend.mybatis.encrypt.FieldSecurityHolder;
import com.relaxed.extend.mybatis.encrypt.FieldSecurityProperties;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;

@Component
public class FieldEncryptHelper {
    private static final Logger log = LoggerFactory.getLogger(FieldEncryptHelper.class);
    private static FieldSecurityHolder FILED_SEC_HOLDER = FieldSecurityHolder.INSTANCE;
    private final FieldSecurityProperties fieldSecurityProperties;

    public FieldEncryptor getFieldEncryptor() {
        String defSec = this.fieldSecurityProperties.getDefSec();
        FieldEncryptor encryptor = FILED_SEC_HOLDER.getByType(defSec);
        Assert.notNull((Object)encryptor, (String)"\u52a0\u5bc6\u7b97\u6cd5:{},\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{defSec});
        return encryptor;
    }

    public void encrypt(Object obj) {
        if (ClassUtil.isPrimitiveWrapper(obj.getClass())) {
            return;
        }
        this.encryptOrDecrypt(obj, true);
    }

    public void decrypt(Object obj) {
        this.encryptOrDecrypt(obj, false);
    }

    public void decrypt(Collection list) {
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        list.forEach(this::decrypt);
    }

    private void encryptOrDecrypt(Object obj, boolean encrypt) {
        if (Objects.isNull(obj)) {
            return;
        }
        this.handleObject(obj, encrypt);
    }

    public static Object clone(Object source) {
        Object result = BeanUtils.instantiateClass(source.getClass());
        BeanUtils.copyProperties((Object)source, (Object)result);
        return result;
    }

    private void handleObject(Object obj, boolean encrypt) {
        FieldEncrypt fieldEncrypt = (FieldEncrypt)AnnotationUtils.findAnnotation(obj.getClass(), FieldEncrypt.class);
        if (ObjectUtil.isNull((Object)fieldEncrypt)) {
            return;
        }
        List encryptFields = FieldUtils.getFieldsListWithAnnotation(obj.getClass(), FieldEncrypt.class);
        if (CollectionUtils.isEmpty((Collection)encryptFields)) {
            return;
        }
        for (Field field : encryptFields) {
            String oldValue;
            if (!ClassUtil.isAssignable(String.class, field.getType()) || StringUtils.isBlank((CharSequence)(oldValue = (String)ReflectUtil.getFieldValue((Object)obj, (Field)field)))) continue;
            String logText = null;
            String newValue = null;
            if (encrypt) {
                logText = "encrypt";
                newValue = this.getFieldEncryptor().encrypt(oldValue);
            } else {
                logText = "decrypt";
                newValue = this.getFieldEncryptor().decrypt(oldValue);
            }
            log.info("{} success[{}=>{}]. before:{}, after:{}", new Object[]{logText, field.getDeclaringClass().getName(), field.getName(), oldValue, newValue});
            ReflectUtil.setFieldValue((Object)obj, (Field)field, (Object)newValue);
        }
    }

    public void encrypt(Class<?> entityClass, MultiValueMap<String, String> mpMap, Map<String, Object> paramNameValuePairs) {
        FieldEncrypt fieldEncrypt = (FieldEncrypt)AnnotationUtils.findAnnotation(entityClass, FieldEncrypt.class);
        if (ObjectUtil.isNull((Object)fieldEncrypt)) {
            return;
        }
        List encryptFields = FieldUtils.getFieldsListWithAnnotation(entityClass, FieldEncrypt.class);
        if (CollectionUtils.isEmpty((Collection)encryptFields)) {
            return;
        }
        for (Field field : encryptFields) {
            if (!ClassUtil.isAssignable(String.class, field.getType())) continue;
            String underlineCaseName = StrUtil.toUnderlineCase((CharSequence)field.getName());
            List list = (List)mpMap.get((Object)underlineCaseName);
            for (String mapKey : list) {
                String oldValue = (String)paramNameValuePairs.get(mapKey);
                if (StringUtils.isBlank((CharSequence)oldValue)) continue;
                String newValue = this.getFieldEncryptor().encrypt(oldValue);
                log.info("{} success[{}=>{}]. before:{}, after:{}", new Object[]{"encrypt", field.getDeclaringClass().getName(), field.getName(), oldValue, newValue});
                paramNameValuePairs.put(mapKey, newValue);
            }
        }
    }

    public FieldEncryptHelper(FieldSecurityProperties fieldSecurityProperties) {
        this.fieldSecurityProperties = fieldSecurityProperties;
    }
}

