/*
 * Decompiled with CFR 0.152.
 */
package com.relaxed.common.translation.tts.google;

import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.URLUtil;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.http.HttpUtil;
import com.relaxed.common.translation.core.AbstractTranslationRequest;
import com.relaxed.common.translation.core.TranslationResponse;
import com.relaxed.common.translation.enums.TransEnum;
import com.relaxed.common.translation.tookit.TokenUtils;
import com.relaxed.common.translation.tts.TTSParam;
import com.relaxed.common.translation.tts.TTSResponse;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Map;

public class GoogleTTSRequest
extends AbstractTranslationRequest<TTSParam> {
    private static final String GOOGLE_URL = "https://translate.googleapis.com/translate_tts";

    @Override
    public String getUrl() {
        return GOOGLE_URL;
    }

    @Override
    public TransEnum tsType() {
        return TransEnum.TTS;
    }

    @Override
    public String put(Map<String, String> formData) {
        return URLUtil.buildQuery(formData, (Charset)CharsetUtil.CHARSET_UTF_8);
    }

    @Override
    protected Map<String, String> fillFormData(Map<String, String> formData) {
        formData.put("ie", "UTF-8");
        formData.put("q", ((TTSParam)this.translationParam).getText());
        formData.put("tl", (String)this.langMap.get((Object)((TTSParam)this.translationParam).getFrom()));
        formData.put("total", String.valueOf(1));
        formData.put("idx", String.valueOf(0));
        formData.put("textlen", String.valueOf(11));
        formData.put("tk", TokenUtils.token("tk/Google.js", ((TTSParam)this.translationParam).getText()));
        formData.put("client", "t");
        return formData;
    }

    @Override
    public <T> TranslationResponse<T> execute(String params) {
        String url = this.getUrl();
        String urlString = url + "?" + params;
        StringBuilder saveFile = new StringBuilder();
        String filename = SecureUtil.md5((String)urlString) + ".mp3";
        saveFile.append(((TTSParam)this.translationParam).getDownloadPath()).append(File.separator).append(filename);
        String destPath = saveFile.toString();
        HttpUtil.downloadFile((String)urlString, (String)destPath);
        return TranslationResponse.ok(new TTSResponse(filename, destPath));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GoogleTTSRequest)) {
            return false;
        }
        GoogleTTSRequest other = (GoogleTTSRequest)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof GoogleTTSRequest;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public String toString() {
        return "GoogleTTSRequest()";
    }
}

