/*
 * Decompiled with CFR 0.152.
 */
package com.relaxed.common.translation.trans.tencent;

import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.URLUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.relaxed.common.translation.core.AbstractTranslationRequest;
import com.relaxed.common.translation.core.TranslationResponse;
import com.relaxed.common.translation.enums.LangEnum;
import com.relaxed.common.translation.enums.TransEnum;
import com.relaxed.common.translation.trans.TransParam;
import com.relaxed.common.translation.trans.TransResponse;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;

public class TencentRequest
extends AbstractTranslationRequest<TransParam> {
    private static final String GOOGLE_URL = "https://fanyi.qq.com/api/translate";
    protected Map<String, String> formData = new HashMap<String, String>();

    @Override
    public String getUrl() {
        return GOOGLE_URL;
    }

    @Override
    public TransEnum tsType() {
        return TransEnum.TTL;
    }

    @Override
    public String put(Map<String, String> formData) {
        return URLUtil.buildQuery(formData, (Charset)CharsetUtil.CHARSET_UTF_8);
    }

    @Override
    protected void initDefaultLangSupport() {
        this.langMap.put(LangEnum.ZH, "zh");
        this.langMap.put(LangEnum.EN, "en");
        this.langMap.put(LangEnum.JP, "jp");
        this.langMap.put(LangEnum.KOR, "kr");
        this.langMap.put(LangEnum.FRA, "fr");
        this.langMap.put(LangEnum.RU, "ru");
        this.langMap.put(LangEnum.DE, "de");
    }

    @Override
    protected Map<String, String> fillFormData(Map<String, String> formData) {
        String text = ((TransParam)this.translationParam).getText();
        LangEnum from = ((TransParam)this.translationParam).getFrom();
        LangEnum to = ((TransParam)this.translationParam).getTo();
        formData.put("source", (String)this.langMap.get((Object)from));
        formData.put("target", (String)this.langMap.get((Object)to));
        formData.put("sourceText", text);
        formData.put("sessionUuid", "translate_uuid" + System.currentTimeMillis());
        return formData;
    }

    @Override
    public <T> TranslationResponse<T> execute(String param) {
        String url = this.getUrl();
        HttpRequest httpRequest = HttpUtil.createPost((String)url);
        httpRequest.header("Origin", "https://fanyi.qq.com");
        httpRequest.header("Cookie", "pgv_pvid=767342458; pac_uid=0_6f0ef13264e20; fy_guid=f723499b-16ad-48da-b144-6637c1be2b4e; ADHOC_MEMBERSHIP_CLIENT_ID1.0=7e20e661-e7ef-8eca-5e6a-3f3dc383ec6a; openCount=1; qtv=cade9ddc0b49b29b; qtk=ByVDELJQjDTjqgQwKHyRQUYr/K0YfdreUg8mq5Xm7c3ge1XzCmiI6m8yS6AsH3LJwjckKt6jqG4rbOjn0xIPbdLayhuBpcY7/pwxoRwtZC0I7VhR83lX+MFOQlNSKoqdq/R0BHf3dnDZommFrH+Ptg==; gr_user_id=b292abdc-a7c9-41e0-b3f2-009795c4de2c; 8507d3409e6fad23_gr_session_id=09c9a463-06f7-4f73-8918-eaf15b2ddf42; 8507d3409e6fad23_gr_session_id_09c9a463-06f7-4f73-8918-eaf15b2ddf42=true");
        httpRequest.body(param);
        String result = httpRequest.execute().body();
        String realResult = TencentRequest.parseResult(result);
        return TranslationResponse.ok(new TransResponse(realResult));
    }

    private static String parseResult(String text) {
        ObjectMapper mapper = new ObjectMapper();
        return mapper.readTree(text).path("translate").findPath("targetText").toString();
    }

    public Map<String, String> getFormData() {
        return this.formData;
    }

    public void setFormData(Map<String, String> formData) {
        this.formData = formData;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TencentRequest)) {
            return false;
        }
        TencentRequest other = (TencentRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, String> this$formData = this.getFormData();
        Map<String, String> other$formData = other.getFormData();
        return !(this$formData == null ? other$formData != null : !((Object)this$formData).equals(other$formData));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TencentRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, String> $formData = this.getFormData();
        result = result * 59 + ($formData == null ? 43 : ((Object)$formData).hashCode());
        return result;
    }

    public String toString() {
        return "TencentRequest(formData=" + this.getFormData() + ")";
    }
}

