/*
 * Decompiled with CFR 0.152.
 */
package com.relaxed.common.translation.trans.google;

import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.URLUtil;
import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONArray;
import com.relaxed.common.translation.core.AbstractTranslationRequest;
import com.relaxed.common.translation.core.TranslationResponse;
import com.relaxed.common.translation.enums.TransEnum;
import com.relaxed.common.translation.tookit.TokenUtils;
import com.relaxed.common.translation.trans.TransParam;
import com.relaxed.common.translation.trans.TransResponse;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;

public class GoogleRequest
extends AbstractTranslationRequest<TransParam> {
    private static final String GOOGLE_URL = "https://translate.googleapis.com/translate_a/single";
    protected Map<String, String> formData = new HashMap<String, String>();

    @Override
    public String getUrl() {
        return GOOGLE_URL;
    }

    @Override
    public TransEnum tsType() {
        return TransEnum.TTL;
    }

    @Override
    public String put(Map<String, String> formData) {
        return URLUtil.buildQuery(formData, (Charset)CharsetUtil.CHARSET_UTF_8);
    }

    @Override
    protected Map<String, String> fillFormData(Map<String, String> formData) {
        String text = ((TransParam)this.translationParam).getText();
        formData.put("client", "t");
        formData.put("sl", (String)this.langMap.get((Object)((TransParam)this.translationParam).getFrom()));
        formData.put("tl", (String)this.langMap.get((Object)((TransParam)this.translationParam).getTo()));
        formData.put("hl", "zh-CN");
        formData.put("dt", "at");
        formData.put("dt", "bd");
        formData.put("dt", "ex");
        formData.put("dt", "ld");
        formData.put("dt", "md");
        formData.put("dt", "qca");
        formData.put("dt", "rw");
        formData.put("dt", "rm");
        formData.put("dt", "ss");
        formData.put("dt", "t");
        formData.put("ie", "UTF-8");
        formData.put("oe", "UTF-8");
        formData.put("source", "btn");
        formData.put("ssel", "0");
        formData.put("tsel", "0");
        formData.put("kc", "0");
        formData.put("tk", TokenUtils.token("tk/Google.js", text));
        formData.put("q", text);
        return formData;
    }

    @Override
    public <T> TranslationResponse<T> execute(String param) {
        String url = this.getUrl();
        String urlString = url + "?" + param;
        String result = HttpUtil.get((String)urlString);
        String realResult = GoogleRequest.parseResult(result);
        return TranslationResponse.ok(new TransResponse(realResult));
    }

    private static String parseResult(String inputJson) {
        JSONArray jsonArray2 = (JSONArray)new JSONArray((Object)inputJson).get(0);
        StringBuilder result = new StringBuilder();
        for (Object o : jsonArray2) {
            result.append(((JSONArray)o).get(0).toString());
        }
        return result.toString();
    }

    public Map<String, String> getFormData() {
        return this.formData;
    }

    public void setFormData(Map<String, String> formData) {
        this.formData = formData;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GoogleRequest)) {
            return false;
        }
        GoogleRequest other = (GoogleRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, String> this$formData = this.getFormData();
        Map<String, String> other$formData = other.getFormData();
        return !(this$formData == null ? other$formData != null : !((Object)this$formData).equals(other$formData));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GoogleRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, String> $formData = this.getFormData();
        result = result * 59 + ($formData == null ? 43 : ((Object)$formData).hashCode());
        return result;
    }

    public String toString() {
        return "GoogleRequest(formData=" + this.getFormData() + ")";
    }
}

