/*
 * Decompiled with CFR 0.152.
 */
package com.relaxed.common.translation.querier;

import com.relaxed.common.translation.core.AbstractTranslationRequest;
import com.relaxed.common.translation.core.TranslationParam;
import com.relaxed.common.translation.core.TranslationResponse;
import com.relaxed.common.translation.core.Translator;
import com.relaxed.common.translation.trans.google.GoogleRequest;
import com.relaxed.common.translation.trans.tencent.TencentRequest;
import com.relaxed.common.translation.tts.google.GoogleTTSRequest;
import java.util.ArrayList;
import java.util.List;

public class Querier<T extends AbstractTranslationRequest> {
    private List<T> collection = new ArrayList<T>();
    private Translator translator = new Translator();

    private Querier() {
    }

    public static <T extends AbstractTranslationRequest> Querier<T> trans() {
        Querier<AbstractTranslationRequest> querier = new Querier<AbstractTranslationRequest>();
        querier.attach(new GoogleRequest());
        querier.attach(new TencentRequest());
        return querier;
    }

    public static <T extends AbstractTranslationRequest> Querier<T> tts() {
        Querier<GoogleTTSRequest> querier = new Querier<GoogleTTSRequest>();
        querier.attach(new GoogleTTSRequest());
        return querier;
    }

    public <P extends TranslationParam, R> TranslationResponse<R> execute(P param) {
        for (AbstractTranslationRequest command : this.collection) {
            command.setTranslationParam(param);
            TranslationResponse translate = this.translator.translate(command);
            if (!translate.success()) continue;
            return translate;
        }
        return null;
    }

    public void attach(T command) {
        this.collection.add(command);
    }

    public void detach(T command) {
        this.collection.remove(command);
    }
}

