/*
 * Decompiled with CFR 0.152.
 */
package com.relaxed.common.translation.core;

import com.relaxed.common.translation.core.TranslationParam;
import com.relaxed.common.translation.core.TranslationRequest;
import com.relaxed.common.translation.enums.LangEnum;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractTranslationRequest<P extends TranslationParam>
implements TranslationRequest {
    protected Map<LangEnum, String> langMap = new HashMap<LangEnum, String>();
    protected Map<String, String> formData = new HashMap<String, String>();
    protected P translationParam;

    public void setTranslationParam(P translationParam) {
        this.translationParam = translationParam;
    }

    protected AbstractTranslationRequest() {
        this.init();
    }

    protected void init() {
        this.initDefaultLangSupport();
    }

    @Override
    public String generateParam() {
        return this.put(this.fillFormData(this.formData));
    }

    protected Map<String, String> fillFormData(Map<String, String> formData) {
        return formData;
    }

    public abstract String put(Map<String, String> var1);

    protected void initDefaultLangSupport() {
        this.langMap.put(LangEnum.ZH, "zh-CN");
        this.langMap.put(LangEnum.EN, "en");
        this.langMap.put(LangEnum.JP, "ja");
        this.langMap.put(LangEnum.KOR, "ko");
        this.langMap.put(LangEnum.FRA, "fr");
        this.langMap.put(LangEnum.RU, "ru");
        this.langMap.put(LangEnum.DE, "de");
    }

    protected void addLangSupport(LangEnum source, String val) {
        this.langMap.put(source, val);
    }

    protected void delLangSupport(LangEnum source) {
        this.langMap.remove((Object)source);
    }
}

