/*
 * Decompiled with CFR 0.152.
 */
package com.relaxed.common.tenant.utils;

import com.relaxed.common.tenant.core.Tenant;
import com.relaxed.common.tenant.core.table.DataScope;
import java.util.List;
import java.util.Objects;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.update.Update;

public class ExpressionUtil {
    public static void fillTableSchema(Table table, Tenant tenant) {
        if (tenant.isSchema()) {
            table.setSchemaName(tenant.getSchemaName());
        }
    }

    public static void fillTableSchema(Statement statement, Tenant tenant) {
        if (statement instanceof Insert) {
            Insert insert = (Insert)statement;
            if (tenant.isSchema()) {
                Table table = insert.getTable();
                table.setSchemaName(tenant.getSchemaName());
                insert.setTable(table);
            }
        } else if (statement instanceof Update) {
            Update update = (Update)statement;
            if (tenant.isSchema()) {
                Table table = update.getTable();
                table.setSchemaName(tenant.getSchemaName());
                update.setTable(table);
                List startJoins = update.getStartJoins();
                if (startJoins != null && startJoins.size() > 0) {
                    for (Join startJoin : startJoins) {
                        Table rightItem = (Table)startJoin.getRightItem();
                        rightItem.setSchemaName(tenant.getSchemaName());
                    }
                }
            }
        } else if (statement instanceof Delete) {
            Delete delete = (Delete)statement;
            if (tenant.isSchema()) {
                Table table = delete.getTable();
                table.setSchemaName(tenant.getSchemaName());
                delete.setTable(table);
            }
        }
    }

    public static Expression injectExpressionNoWhere(Table table, Tenant tenant, StringBuilder builder) {
        if (tenant.isTable()) {
            builder.append(" WHERE ");
            return ExpressionUtil.injectExpressionNoWhere(table, tenant);
        }
        return null;
    }

    public static Expression injectExpressionNoWhere(Table table, Tenant tenant) {
        String tableName = table.getName();
        List<DataScope> dataScopes = tenant.getDataScopes();
        Expression dataFilterExpression = dataScopes.stream().filter(x -> x.getTableNames().contains(tableName)).map(x -> x.getExpression(tableName, table.getAlias())).filter(Objects::nonNull).reduce(AndExpression::new).orElse(null);
        return dataFilterExpression;
    }

    public static Expression injectExpression(Expression currentExpression, Table table, Tenant tenant) {
        String tableName = table.getName();
        if (!tenant.isTable()) {
            return currentExpression;
        }
        List<DataScope> dataScopes = tenant.getDataScopes();
        Expression dataFilterExpression = dataScopes.stream().filter(x -> x.getTableNames().contains(tableName)).map(x -> x.getExpression(tableName, table.getAlias())).filter(Objects::nonNull).reduce(AndExpression::new).orElse(null);
        if (currentExpression == null) {
            return dataFilterExpression;
        }
        if (dataFilterExpression == null) {
            return currentExpression;
        }
        if (currentExpression instanceof OrExpression) {
            return new AndExpression((Expression)new Parenthesis(currentExpression), dataFilterExpression);
        }
        return new AndExpression(currentExpression, dataFilterExpression);
    }
}

