/*
 * Decompiled with CFR 0.152.
 */
package com.relaxed.common.tenant.parse;

import com.relaxed.common.tenant.core.Tenant;
import com.relaxed.common.tenant.exception.TenantException;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.StatementVisitor;
import net.sf.jsqlparser.util.deparser.StatementDeParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SqlParser {
    private static final Logger log = LoggerFactory.getLogger(SqlParser.class);

    public String processSql(String originalSql, Object obj) {
        try {
            Statement stmt = CCJSqlParserUtil.parse((String)originalSql);
            return this.processStatement(stmt, obj, originalSql);
        }
        catch (JSQLParserException e) {
            throw new TenantException(String.format("Failed to process, Error SQL: %s", originalSql), e);
        }
    }

    protected String processStatement(Statement statement, Object obj, String sql) {
        if (log.isDebugEnabled()) {
            log.info("start handle sql  {}", (Object)sql);
        }
        Tenant tenant = (Tenant)obj;
        StringBuilder stringBuffer = new StringBuilder();
        StatementDeParser statementDeParser = this.getStatementDeParser(stringBuffer, tenant);
        statement.accept((StatementVisitor)statementDeParser);
        String replaceSql = stringBuffer.toString();
        if (log.isDebugEnabled()) {
            log.info("end handle sql ,after handle sql  {}", (Object)replaceSql);
        }
        return replaceSql;
    }

    protected StatementDeParser getStatementDeParser(StringBuilder builder, Tenant tenant) {
        throw new TenantException("statementDeParser must be provide");
    }
}

