/*
 * Decompiled with CFR 0.152.
 */
package com.relaxed.common.tenant.parse;

import com.relaxed.common.tenant.core.Tenant;
import com.relaxed.common.tenant.parse.ExtensionExpressionDeParser;
import com.relaxed.common.tenant.parse.ExtensionSelectVisitor;
import com.relaxed.common.tenant.utils.ExpressionUtil;
import java.util.Iterator;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectVisitor;
import net.sf.jsqlparser.statement.select.WithItem;
import net.sf.jsqlparser.statement.update.Update;
import net.sf.jsqlparser.util.deparser.DeleteDeParser;
import net.sf.jsqlparser.util.deparser.ExpressionDeParser;
import net.sf.jsqlparser.util.deparser.InsertDeParser;
import net.sf.jsqlparser.util.deparser.StatementDeParser;
import net.sf.jsqlparser.util.deparser.UpdateDeParser;

public class ExtensionStatementDeParser
extends StatementDeParser {
    private Tenant tenant;

    public ExtensionStatementDeParser(StringBuilder buffer, Tenant tenant) {
        super(buffer);
        this.tenant = tenant;
    }

    public void visit(Insert insert) {
        ExpressionUtil.fillTableSchema((Statement)insert, this.getTenant());
        ExtensionExpressionDeParser expressionDeParser = new ExtensionExpressionDeParser();
        ExtensionSelectVisitor parser = new ExtensionSelectVisitor((ExpressionVisitor)expressionDeParser, this.getBuffer());
        parser.setTenant(this.getTenant());
        parser.setBuffer(this.getBuffer());
        expressionDeParser.setSelectVisitor((SelectVisitor)parser);
        expressionDeParser.setBuffer(this.getBuffer());
        InsertDeParser insertDeParser = new InsertDeParser((ExpressionVisitor)expressionDeParser, (SelectVisitor)parser, this.getBuffer());
        insertDeParser.deParse(insert);
    }

    public void visit(Update update) {
        ExpressionUtil.fillTableSchema((Statement)update, this.getTenant());
        ExtensionExpressionDeParser expressionDeParser = new ExtensionExpressionDeParser();
        ExtensionSelectVisitor parser = new ExtensionSelectVisitor((ExpressionVisitor)expressionDeParser, this.getBuffer());
        parser.setTenant(this.getTenant());
        parser.setBuffer(this.getBuffer());
        expressionDeParser.setSelectVisitor((SelectVisitor)parser);
        expressionDeParser.setBuffer(this.getBuffer());
        Expression whereExpression = update.getWhere();
        update.setWhere(this.processWhereExpression(whereExpression, update.getTable(), expressionDeParser, this.getBuffer(), this.getTenant()));
        UpdateDeParser updateDeParser = new UpdateDeParser((ExpressionVisitor)expressionDeParser, this.getBuffer());
        updateDeParser.deParse(update);
    }

    public void visit(Delete delete) {
        ExpressionUtil.fillTableSchema((Statement)delete, this.getTenant());
        ExtensionExpressionDeParser expressionDeParser = new ExtensionExpressionDeParser();
        ExtensionSelectVisitor parser = new ExtensionSelectVisitor((ExpressionVisitor)expressionDeParser, this.getBuffer());
        parser.setTenant(this.getTenant());
        parser.setBuffer(this.getBuffer());
        parser.setExpressionVisitor((ExpressionVisitor)expressionDeParser);
        expressionDeParser.setSelectVisitor((SelectVisitor)parser);
        expressionDeParser.setBuffer(this.getBuffer());
        Expression whereExpression = delete.getWhere();
        delete.setWhere(this.processWhereExpression(whereExpression, delete.getTable(), expressionDeParser, this.getBuffer(), this.getTenant()));
        DeleteDeParser deleteDeParser = new DeleteDeParser((ExpressionVisitor)expressionDeParser, this.getBuffer());
        deleteDeParser.deParse(delete);
    }

    public void visit(Select select) {
        ExtensionExpressionDeParser expressionDeParser = new ExtensionExpressionDeParser();
        ExtensionSelectVisitor parser = new ExtensionSelectVisitor((ExpressionVisitor)expressionDeParser, this.getBuffer());
        parser.setTenant(this.getTenant());
        parser.setExpressionVisitor((ExpressionVisitor)expressionDeParser);
        expressionDeParser.setSelectVisitor((SelectVisitor)parser);
        expressionDeParser.setBuffer(this.getBuffer());
        if (select.getWithItemsList() != null && !select.getWithItemsList().isEmpty()) {
            this.getBuffer().append("WITH ");
            Iterator iter = select.getWithItemsList().iterator();
            while (iter.hasNext()) {
                WithItem withItem = (WithItem)iter.next();
                withItem.accept((SelectVisitor)parser);
                if (iter.hasNext()) {
                    this.getBuffer().append(",");
                }
                this.getBuffer().append(" ");
            }
        }
        select.getSelectBody().accept((SelectVisitor)parser);
    }

    protected Expression processWhereExpression(Expression whereExpression, Table table, ExpressionDeParser expressionDeParser, StringBuilder builder, Tenant tenant) {
        if (whereExpression == null) {
            whereExpression = ExpressionUtil.injectExpressionNoWhere(table, tenant, builder);
            if (whereExpression != null) {
                whereExpression.accept((ExpressionVisitor)expressionDeParser);
            }
        } else {
            whereExpression = ExpressionUtil.injectExpression(whereExpression, table, this.getTenant());
        }
        return whereExpression;
    }

    public Tenant getTenant() {
        return this.tenant;
    }

    public void setTenant(Tenant tenant) {
        this.tenant = tenant;
    }
}

