/*
 * Decompiled with CFR 0.152.
 */
package com.relaxed.common.tenant.parse;

import com.relaxed.common.tenant.core.Tenant;
import com.relaxed.common.tenant.utils.ExpressionUtil;
import java.util.Iterator;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.OracleHint;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.select.First;
import net.sf.jsqlparser.statement.select.FromItemVisitor;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.OptimizeFor;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SelectItemVisitor;
import net.sf.jsqlparser.statement.select.Skip;
import net.sf.jsqlparser.statement.select.Top;
import net.sf.jsqlparser.util.deparser.GroupByDeParser;
import net.sf.jsqlparser.util.deparser.LimitDeparser;
import net.sf.jsqlparser.util.deparser.OrderByDeParser;
import net.sf.jsqlparser.util.deparser.SelectDeParser;

public class ExtensionSelectVisitor
extends SelectDeParser {
    private Tenant tenant;

    public ExtensionSelectVisitor(ExpressionVisitor expressionVisitor, StringBuilder buffer) {
        super(expressionVisitor, buffer);
    }

    public Tenant getTenant() {
        return this.tenant;
    }

    public void setTenant(Tenant tenant) {
        this.tenant = tenant;
    }

    public void visit(PlainSelect plainSelect) {
        Expression whereExpression;
        Top top;
        First first;
        Skip skip;
        OracleHint hint;
        if (plainSelect.isUseBrackets()) {
            this.getBuffer().append("(");
        }
        this.getBuffer().append("SELECT ");
        if (plainSelect.getMySqlHintStraightJoin()) {
            this.getBuffer().append("STRAIGHT_JOIN ");
        }
        if ((hint = plainSelect.getOracleHint()) != null) {
            this.getBuffer().append(hint).append(" ");
        }
        if ((skip = plainSelect.getSkip()) != null) {
            this.getBuffer().append(skip).append(" ");
        }
        if ((first = plainSelect.getFirst()) != null) {
            this.getBuffer().append(first).append(" ");
        }
        if (plainSelect.getDistinct() != null) {
            if (plainSelect.getDistinct().isUseUnique()) {
                this.getBuffer().append("UNIQUE ");
            } else {
                this.getBuffer().append("DISTINCT ");
            }
            if (plainSelect.getDistinct().getOnSelectItems() != null) {
                this.getBuffer().append("ON (");
                Iterator iter = plainSelect.getDistinct().getOnSelectItems().iterator();
                while (iter.hasNext()) {
                    SelectItem selectItem = (SelectItem)iter.next();
                    selectItem.accept((SelectItemVisitor)this);
                    if (!iter.hasNext()) continue;
                    this.getBuffer().append(", ");
                }
                this.getBuffer().append(") ");
            }
        }
        if ((top = plainSelect.getTop()) != null) {
            this.getBuffer().append(top).append(" ");
        }
        if (plainSelect.getMySqlSqlNoCache()) {
            this.getBuffer().append("SQL_NO_CACHE").append(" ");
        }
        if (plainSelect.getMySqlSqlCalcFoundRows()) {
            this.getBuffer().append("SQL_CALC_FOUND_ROWS").append(" ");
        }
        Iterator iter = plainSelect.getSelectItems().iterator();
        while (iter.hasNext()) {
            SelectItem selectItem = (SelectItem)iter.next();
            selectItem.accept((SelectItemVisitor)this);
            if (!iter.hasNext()) continue;
            this.getBuffer().append(", ");
        }
        if (plainSelect.getIntoTables() != null) {
            this.getBuffer().append(" INTO ");
            iter = plainSelect.getIntoTables().iterator();
            while (iter.hasNext()) {
                this.visit((Table)iter.next());
                if (!iter.hasNext()) continue;
                this.getBuffer().append(", ");
            }
        }
        if (plainSelect.getFromItem() != null) {
            this.getBuffer().append(" FROM ");
            plainSelect.getFromItem().accept((FromItemVisitor)this);
        }
        if (plainSelect.getJoins() != null) {
            for (Join join : plainSelect.getJoins()) {
                this.deparseJoin(join);
            }
        }
        if (plainSelect.getKsqlWindow() != null) {
            this.getBuffer().append(" WINDOW ");
            this.getBuffer().append(plainSelect.getKsqlWindow().toString());
        }
        if ((whereExpression = plainSelect.getWhere()) != null) {
            this.getBuffer().append(" WHERE ");
            if (whereExpression != null) {
                Table fromItem = (Table)plainSelect.getFromItem();
                whereExpression = ExpressionUtil.injectExpression(whereExpression, fromItem, this.getTenant());
            }
            whereExpression.accept(super.getExpressionVisitor());
        } else {
            whereExpression = ExpressionUtil.injectExpressionNoWhere((Table)plainSelect.getFromItem(), this.getTenant(), this.getBuffer());
            if (whereExpression != null) {
                whereExpression.accept(super.getExpressionVisitor());
            }
        }
        if (plainSelect.getOracleHierarchical() != null) {
            plainSelect.getOracleHierarchical().accept(super.getExpressionVisitor());
        }
        if (plainSelect.getGroupBy() != null) {
            this.getBuffer().append(" ");
            new GroupByDeParser(super.getExpressionVisitor(), this.getBuffer()).deParse(plainSelect.getGroupBy());
        }
        if (plainSelect.getHaving() != null) {
            this.getBuffer().append(" HAVING ");
            plainSelect.getHaving().accept(super.getExpressionVisitor());
        }
        if (plainSelect.getOrderByElements() != null) {
            new OrderByDeParser(super.getExpressionVisitor(), this.getBuffer()).deParse(plainSelect.isOracleSiblings(), plainSelect.getOrderByElements());
        }
        if (plainSelect.getLimit() != null) {
            new LimitDeparser(this.getBuffer()).deParse(plainSelect.getLimit());
        }
        if (plainSelect.getOffset() != null) {
            this.deparseOffset(plainSelect.getOffset());
        }
        if (plainSelect.getFetch() != null) {
            this.deparseFetch(plainSelect.getFetch());
        }
        if (plainSelect.isForUpdate()) {
            this.getBuffer().append(" FOR UPDATE");
            if (plainSelect.getForUpdateTable() != null) {
                this.getBuffer().append(" OF ").append(plainSelect.getForUpdateTable());
            }
            if (plainSelect.getWait() != null) {
                this.getBuffer().append(plainSelect.getWait());
            }
            if (plainSelect.isNoWait()) {
                this.getBuffer().append(" NOWAIT");
            }
        }
        if (plainSelect.getOptimizeFor() != null) {
            this.deparseOptimizeFor(plainSelect.getOptimizeFor());
        }
        if (plainSelect.getForXmlPath() != null) {
            this.getBuffer().append(" FOR XML PATH(").append(plainSelect.getForXmlPath()).append(")");
        }
        if (plainSelect.isUseBrackets()) {
            this.getBuffer().append(")");
        }
    }

    private void deparseOptimizeFor(OptimizeFor optimizeFor) {
        this.getBuffer().append(" OPTIMIZE FOR ");
        this.getBuffer().append(optimizeFor.getRowCount());
        this.getBuffer().append(" ROWS");
    }

    public void visit(Table table) {
        ExpressionUtil.fillTableSchema(table, this.getTenant());
        super.visit(table);
    }
}

