/*
 * Decompiled with CFR 0.152.
 */
package com.relaxed.common.tenant.interceptor;

import com.relaxed.common.tenant.core.Tenant;
import com.relaxed.common.tenant.core.schema.SchemaHandler;
import com.relaxed.common.tenant.core.table.DataScope;
import com.relaxed.common.tenant.core.table.TableHandler;
import com.relaxed.common.tenant.parse.SqlParser;
import com.relaxed.common.tenant.utils.PluginUtils;
import java.sql.Connection;
import java.util.List;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class})})
public class TenantInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(TenantInterceptor.class);
    private final SchemaHandler schemaHandler;
    private final TableHandler tableHandler;
    private final SqlParser sqlParser;

    public Object intercept(Invocation invocation) throws Throwable {
        boolean enableSchema = this.schemaHandler.enable();
        boolean enableTable = this.tableHandler.enable();
        if (!enableSchema && !enableTable) {
            return invocation.proceed();
        }
        Tenant tenant = new Tenant();
        Object target = invocation.getTarget();
        StatementHandler sh = (StatementHandler)target;
        PluginUtils.MPStatementHandler mpSh = PluginUtils.mpStatementHandler(sh);
        MappedStatement ms = mpSh.mappedStatement();
        String mappedStatementId = ms.getId();
        if (enableSchema) {
            String currentSchema = this.schemaHandler.getCurrentSchema();
            if (currentSchema == null || "".equals(currentSchema) || this.schemaHandler.ignore(currentSchema) || this.schemaHandler.ignoreMethod(mappedStatementId)) {
                tenant.setSchema(false);
            } else {
                tenant.setSchema(true);
                tenant.setSchemaName(currentSchema);
            }
        } else {
            tenant.setSchema(false);
        }
        if (!enableTable || this.tableHandler.ignore(mappedStatementId)) {
            tenant.setTable(false);
        } else {
            tenant.setTable(true);
            List<DataScope> dataScopes = this.tableHandler.filterDataScopes(mappedStatementId);
            if (dataScopes == null || dataScopes.isEmpty()) {
                tenant.setTable(false);
            } else {
                tenant.setDataScopes(dataScopes);
            }
        }
        PluginUtils.MPBoundSql mpBs = mpSh.mPBoundSql();
        String originalSql = mpBs.sql();
        mpBs.sql(this.sqlParser.processSql(originalSql, tenant));
        return invocation.proceed();
    }

    public Object plugin(Object target) {
        if (target instanceof StatementHandler) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public TenantInterceptor(SchemaHandler schemaHandler, TableHandler tableHandler, SqlParser sqlParser) {
        this.schemaHandler = schemaHandler;
        this.tableHandler = tableHandler;
        this.sqlParser = sqlParser;
    }
}

