/*
 * Decompiled with CFR 0.152.
 */
package com.relaxed.common.ip;

import cn.hutool.core.io.IoUtil;
import com.relaxed.common.ip.Ip2RegionProperties;
import com.relaxed.common.ip.Ip2RegionSearcher;
import com.relaxed.common.ip.IpException;
import java.io.InputStream;
import org.lionsoul.ip2region.DbConfig;
import org.lionsoul.ip2region.DbMakerConfigException;
import org.lionsoul.ip2region.DbSearcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={Ip2RegionProperties.class})
@ConditionalOnClass(value={DbSearcher.class})
public class IpAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(IpAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="relaxed.ip", name={"enabled"}, havingValue="true")
    public Ip2RegionSearcher autoIp2regionSearcher(Ip2RegionProperties properties) {
        try {
            InputStream inputStream = IpAutoConfiguration.class.getClassLoader().getResourceAsStream(properties.getDbFile());
            byte[] bytes = IoUtil.readBytes((InputStream)inputStream);
            DbConfig dbConfig = new DbConfig();
            DbSearcher dbSearcher = new DbSearcher(dbConfig, bytes);
            return new Ip2RegionSearcher(dbSearcher);
        }
        catch (DbMakerConfigException inputStream) {
        }
        catch (Exception e) {
            log.error("\u521d\u59cb\u5316ip\u5e93\u5f02\u5e38,\u6587\u4ef6{}", (Object)properties.getDbFile(), (Object)e);
        }
        throw new IpException("IP \u521d\u59cb\u5316\u5f02\u5e38");
    }
}

