/*
 * Decompiled with CFR 0.152.
 */
package com.relaxed.common.idempotent.key;

import cn.hutool.cache.CacheUtil;
import cn.hutool.cache.impl.TimedCache;
import com.relaxed.common.idempotent.key.AbstractIdempotentKeyStore;
import java.util.concurrent.TimeUnit;

public class InMemoryIdempotentKeyStore
extends AbstractIdempotentKeyStore {
    private final TimedCache<String, Long> cache = CacheUtil.newTimedCache((long)Integer.MAX_VALUE);

    public InMemoryIdempotentKeyStore() {
        this.cache.schedulePrune(1L);
    }

    @Override
    public synchronized boolean saveIfAbsent(String key, long duration, TimeUnit timeUnit) {
        Long value = (Long)this.cache.get((Object)key, false);
        if (value == null) {
            long timeOut = TimeUnit.MILLISECONDS.convert(duration, timeUnit);
            this.cache.put((Object)key, (Object)System.currentTimeMillis(), timeOut);
            return true;
        }
        return false;
    }

    @Override
    public void remove(String key) {
        this.cache.remove((Object)key);
    }
}

