/*
 * Decompiled with CFR 0.152.
 */
package com.relaxed.common.idempotent.key;

import com.relaxed.common.core.util.SpELUtil;
import com.relaxed.common.idempotent.annotation.Idempotent;
import com.relaxed.common.idempotent.key.IdempotentKeyStore;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public abstract class AbstractIdempotentKeyStore
implements IdempotentKeyStore {
    @Override
    public String buildIdempotentKey(ProceedingJoinPoint joinPoint, Idempotent idempotentAnnotation) {
        String uniqueExpression = idempotentAnnotation.uniqueExpression();
        if ("".equals(uniqueExpression)) {
            return idempotentAnnotation.prefix();
        }
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        Object[] args = joinPoint.getArgs();
        StandardEvaluationContext spelContext = SpELUtil.getSpElContext((Object)joinPoint.getTarget(), (Method)method, (Object[])args);
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (requestAttributes != null) {
            spelContext.setVariable("request", (Object)requestAttributes.getRequest());
        }
        String uniqueStr = SpELUtil.parseValueToString((EvaluationContext)spelContext, (String)uniqueExpression);
        return idempotentAnnotation.prefix() + ":" + uniqueStr;
    }
}

