/*
 * Decompiled with CFR 0.152.
 */
package com.relaxed.common.idempotent;

import cn.hutool.core.lang.Assert;
import com.relaxed.common.idempotent.annotation.Idempotent;
import com.relaxed.common.idempotent.exception.IdempotentException;
import com.relaxed.common.idempotent.key.IdempotentKeyStore;
import com.relaxed.common.model.result.BaseResultCode;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class IdempotentAspect {
    private static final Logger log = LoggerFactory.getLogger(IdempotentAspect.class);
    private final IdempotentKeyStore idempotentKeyStore;

    @Around(value="@annotation(idempotentAnnotation)")
    public Object around(ProceedingJoinPoint joinPoint, Idempotent idempotentAnnotation) throws Throwable {
        String idempotentKey = this.idempotentKeyStore.buildIdempotentKey(joinPoint, idempotentAnnotation);
        boolean saveSuccess = this.idempotentKeyStore.saveIfAbsent(idempotentKey, idempotentAnnotation.duration(), idempotentAnnotation.timeUnit());
        Assert.isTrue((boolean)saveSuccess, () -> {
            throw new IdempotentException(BaseResultCode.REPEATED_EXECUTE.getCode(), idempotentAnnotation.message());
        });
        try {
            Object result = joinPoint.proceed();
            if (idempotentAnnotation.removeKeyWhenFinished()) {
                this.idempotentKeyStore.remove(idempotentKey);
            }
            return result;
        }
        catch (Throwable e) {
            if (idempotentAnnotation.removeKeyWhenError()) {
                this.idempotentKeyStore.remove(idempotentKey);
            }
            throw e;
        }
    }

    public IdempotentAspect(IdempotentKeyStore idempotentKeyStore) {
        this.idempotentKeyStore = idempotentKeyStore;
    }
}

