/*
 * Decompiled with CFR 0.152.
 */
package com.relaxed.common.exception.notifier;

import com.relaxed.common.exception.domain.ExceptionMessage;
import com.relaxed.common.exception.domain.ExceptionNoticeResult;
import com.relaxed.common.exception.notifier.AbstractExceptionNotifier;
import com.relaxed.extend.wechat.message.WechatMessage;
import com.relaxed.extend.wechat.message.WechatTextMessage;
import com.relaxed.extend.wechat.request.WechatResponse;
import com.relaxed.extend.wechat.request.WechatSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WechatGlobalExceptionNotifier
extends AbstractExceptionNotifier {
    private static final Logger log = LoggerFactory.getLogger(WechatGlobalExceptionNotifier.class);
    private final WechatSender sender;

    public WechatGlobalExceptionNotifier(String channel, String applicationName, WechatSender sender) {
        super(channel, applicationName);
        this.sender = sender;
    }

    @Override
    public ExceptionNoticeResult send(ExceptionMessage sendMessage) {
        WechatResponse response = this.sender.sendMessage((WechatMessage)new WechatTextMessage().setContent(sendMessage.toString()).atAll());
        return new ExceptionNoticeResult().setChannel(this.channel).setSuccess(response.isSuccess()).setErrMsg(response.getResponse());
    }

    public WechatSender getSender() {
        return this.sender;
    }
}

