/*
 * Decompiled with CFR 0.152.
 */
package com.relaxed.common.exception.notifier;

import com.relaxed.common.exception.domain.ExceptionMessage;
import com.relaxed.common.exception.domain.ExceptionNoticeResult;
import com.relaxed.common.exception.notifier.AbstractExceptionNotifier;
import com.relaxed.extend.mail.model.MailSendInfo;
import com.relaxed.extend.mail.sender.MailSender;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailGlobalExceptionNotifier
extends AbstractExceptionNotifier {
    private static final Logger log = LoggerFactory.getLogger(MailGlobalExceptionNotifier.class);
    private final MailSender sender;
    private String[] receiveEmails;

    public MailGlobalExceptionNotifier(String channel, String applicationName, MailSender sender, Set<String> receiveEmails) {
        super(channel, applicationName);
        this.sender = sender;
        this.receiveEmails = receiveEmails.toArray(new String[0]);
    }

    @Override
    public ExceptionNoticeResult send(ExceptionMessage sendMessage) {
        MailSendInfo mailSendInfo = this.sender.sendTextMail("\u5f02\u5e38\u8b66\u544a[\u5e94\u7528:" + this.applicationName + "]", sendMessage.toString(), this.receiveEmails);
        return new ExceptionNoticeResult().setChannel(this.channel).setSuccess(mailSendInfo.getSuccess()).setErrMsg(mailSendInfo.getErrorMsg());
    }

    public MailSender getSender() {
        return this.sender;
    }

    public String[] getReceiveEmails() {
        return this.receiveEmails;
    }
}

